/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.util.Collection;
import org.conqat.lib.commons.math.EAggregationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathUtils {
    public static double sum(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.SUM);
    }

    public static double max(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MAX);
    }

    public static double min(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MIN);
    }

    public static double mean(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MEAN);
    }

    public static double median(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MEDIAN);
    }

    public static double percentile25(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.PERCENTILE25);
    }

    public static double percentile75(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.PERCENTILE75);
    }

    public static double aggregate(Collection<? extends Number> values, EAggregationStrategy aggregation) {
        return aggregation.getAggregator().aggregate(values);
    }

    public static long factorial(int n) {
        long result = 1L;
        for (int i = 2; i <= n; ++i) {
            result *= (long)i;
        }
        return result;
    }

    public static boolean isNormal(double number) {
        return !Double.isInfinite(number) && !Double.isNaN(number);
    }
}

