/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.reflect.EJavaPrimitive;
import org.conqat.lib.commons.reflect.FormalParameter;
import org.conqat.lib.commons.reflect.FormalParameterComparator;
import org.conqat.lib.commons.reflect.GenericTypeResolver;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static FormalParameterComparator comparator = new FormalParameterComparator();

    public static <T> T convertString(String value, Class<T> targetType) throws TypeConversionException {
        if (value == null) {
            if (String.class.equals(targetType)) {
                return (T)"";
            }
            throw new TypeConversionException("Null value can't be converted to type '" + targetType.getName() + "'.");
        }
        if (targetType.equals(Object.class) || targetType.equals(String.class)) {
            return (T)value;
        }
        if (targetType.isPrimitive() || EJavaPrimitive.isWrapperType(targetType)) {
            return ReflectionUtils.convertPrimitive(value, targetType);
        }
        if (targetType.isEnum()) {
            T result = EnumUtils.valueOfIgnoreCase(targetType, value);
            if (result == null) {
                throw new TypeConversionException("'" + value + "' is no valid value for enum " + targetType.getName());
            }
            return result;
        }
        if (targetType.equals(Color.class)) {
            Color result = ColorUtils.fromString(value);
            if (result == null) {
                throw new TypeConversionException("'" + value + "' is not a valid color!");
            }
            return (T)result;
        }
        try {
            Constructor<T> c = targetType.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (Exception e) {
            throw new TypeConversionException("No constructor taking one String argument found for type '" + targetType + "' (" + e.getMessage() + ")", e);
        }
    }

    public static Object convertTo(String valueString, String typeName) throws TypeConversionException, ClassNotFoundException {
        Class<?> clazz = ReflectionUtils.resolveType(typeName);
        return ReflectionUtils.convertString(valueString, clazz);
    }

    public static boolean isConvertibleFromString(Class<?> targetType) {
        if (targetType.equals(Object.class) || targetType.equals(String.class)) {
            return true;
        }
        if (targetType.isPrimitive() || EJavaPrimitive.isWrapperType(targetType)) {
            return true;
        }
        if (targetType.isEnum()) {
            return true;
        }
        if (targetType.equals(Color.class)) {
            return true;
        }
        try {
            targetType.getConstructor(String.class);
            return true;
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static FormalParameter[] getFormalParameters(Method method) {
        int parameterCount = method.getParameterTypes().length;
        FormalParameter[] parameters = new FormalParameter[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameters[i] = new FormalParameter(method, i);
        }
        return parameters;
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList superClasses = new ArrayList();
        ReflectionUtils.findSuperClasses(clazz, superClasses);
        return superClasses;
    }

    public static Object invoke(Method method, Object object, Map<FormalParameter, Object> parameterMap) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (FormalParameter formalParameter : parameterMap.keySet()) {
            if (formalParameter.getMethod().equals(method)) continue;
            throw new IllegalArgumentException("Parameters must belong to method.");
        }
        Object[] parameters = ReflectionUtils.obtainParameters(parameterMap);
        return method.invoke(object, parameters);
    }

    public static boolean isAssignable(Class<?> source, Class<?> target) {
        return ReflectionUtils.resolvePrimitiveClass(target).isAssignableFrom(ReflectionUtils.resolvePrimitiveClass(source));
    }

    public static Class<?> resolvePrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        EJavaPrimitive primitive = EJavaPrimitive.getForPrimitiveClass(clazz);
        if (primitive == null) {
            throw new IllegalStateException("Did Java get a new primitive? " + clazz.getName());
        }
        return primitive.getWrapperClass();
    }

    static <T> T convertPrimitive(String value, Class<T> targetType) throws TypeConversionException {
        EJavaPrimitive primitive = EJavaPrimitive.getForPrimitiveOrWrapperClass(targetType);
        if (primitive == null) {
            throw new IllegalArgumentException("Type '" + targetType.getName() + "' is not a primitive type!");
        }
        try {
            switch (primitive) {
                case BOOLEAN: {
                    boolean b = "1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
                    return (T)Boolean.valueOf(b);
                }
                case CHAR: {
                    return (T)Character.valueOf(value.charAt(0));
                }
                case BYTE: {
                    return (T)Byte.valueOf(value);
                }
                case SHORT: {
                    return (T)Short.valueOf(value);
                }
                case INT: {
                    return (T)Integer.valueOf(value);
                }
                case LONG: {
                    return (T)Long.valueOf(value);
                }
                case FLOAT: {
                    return (T)Float.valueOf(value);
                }
                case DOUBLE: {
                    return (T)Double.valueOf(value);
                }
            }
            throw new TypeConversionException("No conversion possible for " + (Object)((Object)primitive));
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("Value'" + value + "' can't be converted to type '" + targetType.getName() + "' (" + e.getMessage() + ").", e);
        }
    }

    public static Class<?> resolveType(String typeName) throws ClassNotFoundException {
        return ReflectionUtils.resolveType(typeName, null);
    }

    public static Class<?> resolveType(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        EJavaPrimitive primitive = EJavaPrimitive.getPrimitiveIgnoreCase(typeName);
        if (primitive != null) {
            return primitive.getClassObject();
        }
        if (classLoader == null) {
            return Class.forName(typeName);
        }
        return Class.forName(typeName, true, classLoader);
    }

    private static void findSuperClasses(Class<?> clazz, List<Class<?>> superClasses) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        superClasses.add(superClass);
        ReflectionUtils.findSuperClasses(superClass, superClasses);
    }

    private static Object[] obtainParameters(Map<FormalParameter, Object> parameterMap) {
        ArrayList<FormalParameter> formalParameters = new ArrayList<FormalParameter>(parameterMap.keySet());
        Collections.sort(formalParameters, comparator);
        Object[] result = new Object[formalParameters.size()];
        for (int i = 0; i < formalParameters.size(); ++i) {
            result[i] = parameterMap.get(formalParameters.get(i));
        }
        return result;
    }

    public static Class<?> obtainMethodReturnType(Class<?> clazz, String methodName) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isValid(method, methodName)) continue;
            return method.getReturnType();
        }
        throw new NoSuchMethodException("Class " + clazz.getName() + " doesn't have parameterless method named " + methodName);
    }

    public static Class<?> obtainGenericMethodReturnType(Class<?> clazz, String methodName) throws NoSuchMethodException {
        if (clazz.isArray() || clazz.isEnum()) {
            throw new IllegalArgumentException("Doesn't work for arrays and enums.");
        }
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("Doesn't work for generic classes.");
        }
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isValid(method, methodName)) continue;
            return new GenericTypeResolver(clazz).resolveGenericType(method.getGenericReturnType());
        }
        throw new NoSuchMethodException("Class " + clazz.getName() + " doesn't have parameterless method named " + methodName);
    }

    private static boolean isValid(Method method, String methodName) {
        return method.getName().equals(methodName) && method.getParameterTypes().length == 0 && !method.isBridge();
    }

    public static <T> T performNearestClassLookup(Class<?> clazz, Map<Class<?>, T> classMap) {
        LinkedList q = new LinkedList();
        q.add(clazz);
        while (!q.isEmpty()) {
            Class current = (Class)q.poll();
            if (classMap.containsKey(current)) {
                return classMap.get(current);
            }
            Class superClass = current.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                q.add(superClass);
            }
            for (Class<?> iface : current.getInterfaces()) {
                q.add(iface);
            }
        }
        return classMap.get(Object.class);
    }

    public static boolean isInstanceOfAny(Object o, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfAll(Object o, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (c.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    public static <T> T pickInstanceOf(Class<T> clazz, Collection<?> objects) {
        for (Object o : objects) {
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public static Version obtainClassFileVersion(InputStream inputStream) throws IOException {
        DataInputStream classfile = new DataInputStream(inputStream);
        int magic = classfile.readInt();
        if (magic != -889275714) {
            return null;
        }
        int minorVersion = classfile.readUnsignedShort();
        int majorVersion = classfile.readUnsignedShort();
        return new Version(majorVersion, minorVersion);
    }

    public static HashMap<String, Version> getClassFileVersions(File jarFile) throws IOException {
        HashMap<String, Version> result = new HashMap<String, Version>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            InputStream entryStream = jar.getInputStream(entry);
            Version version = ReflectionUtils.obtainClassFileVersion(entryStream);
            result.put(entry.getName(), version);
            entryStream.close();
        }
        jar.close();
        return result;
    }

    public static <T> List<T> listInstances(List<?> objects, Class<T> type) {
        ArrayList filtered = new ArrayList();
        for (Object object : objects) {
            if (!type.isInstance(object)) continue;
            filtered.add(object);
        }
        return filtered;
    }
}

