/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Region
implements Comparable<Region> {
    public static final String UNKNOWN_ORIGIN = "Unkwnon origin";
    private final String origin;
    private final int start;
    private final int end;

    public Region(int start, int end, String origin) {
        this.start = start;
        this.end = end;
        this.origin = origin;
    }

    public Region(int start, int end) {
        this(start, end, UNKNOWN_ORIGIN);
    }

    public boolean containsPosition(int position) {
        return this.start <= position && this.end >= position;
    }

    public boolean overlaps(Region r) {
        if (r.start < this.start) {
            return r.overlaps(this);
        }
        return this.start <= r.start && this.end >= r.start;
    }

    public boolean adjacent(Region r) {
        if (r.start < this.start) {
            return r.adjacent(this);
        }
        return this.end + 1 == r.start;
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public String toString() {
        return "[" + this.start + "-" + this.end + "]";
    }

    @Override
    public int compareTo(Region compareTo) {
        return new Integer(this.start).compareTo(new Integer(compareTo.start));
    }
}

