/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.region;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionSet
implements Set<Region> {
    public static final String ANONYMOUS = "Anonymous";
    private final String name;
    private transient int cleanSize = -1;
    private final Set<Region> inner = new TreeSet<Region>(MemberComparator.access$000());
    private final transient List<Integer> mergedStart = new ArrayList<Integer>();
    private final transient List<Integer> mergedEnd = new ArrayList<Integer>();

    public RegionSet(String name) {
        this.name = name;
    }

    public RegionSet() {
        this.name = ANONYMOUS;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(int position) {
        int k = this.getMergedIndex(position);
        return k >= 0 && position <= this.mergedEnd.get(k);
    }

    public boolean contains(Region region) {
        int k = this.getMergedIndex(region.getStart());
        return k >= 0 && region.getEnd() <= this.mergedEnd.get(k);
    }

    private int getMergedIndex(int position) {
        this.ensureMergedUpToDate();
        int k = Collections.binarySearch(this.mergedStart, position);
        if (k >= 0) {
            return k;
        }
        int insertionPoint = -(k + 1);
        if (insertionPoint == 0) {
            return -1;
        }
        return insertionPoint - 1;
    }

    public boolean containsAny(Region region) {
        int endIndex;
        if (this.contains(region.getStart()) || this.contains(region.getEnd())) {
            return true;
        }
        int startIndex = Collections.binarySearch(this.mergedStart, region.getStart());
        return startIndex != (endIndex = Collections.binarySearch(this.mergedStart, region.getEnd()));
    }

    private void ensureMergedUpToDate() {
        if (this.inner.size() == this.cleanSize) {
            return;
        }
        this.mergedStart.clear();
        this.mergedEnd.clear();
        int start = -1;
        int end = -2;
        for (Region r : this.inner) {
            if (r.getStart() <= end + 1) {
                end = Math.max(end, r.getEnd());
                continue;
            }
            if (start >= 0) {
                this.mergedStart.add(start);
                this.mergedEnd.add(end);
            }
            start = r.getStart();
            end = r.getEnd();
        }
        if (start >= 0) {
            this.mergedStart.add(start);
            this.mergedEnd.add(end);
        }
        this.cleanSize = this.inner.size();
    }

    public int getPositionCount() {
        this.ensureMergedUpToDate();
        int count = 0;
        int size = this.mergedStart.size();
        for (int i = 0; i < size; ++i) {
            count += this.mergedEnd.get(i) - this.mergedStart.get(i) + 1;
        }
        return count;
    }

    public int getLastPosition() {
        if (this.isEmpty()) {
            throw new IllegalStateException("RegionSet is empty");
        }
        this.ensureMergedUpToDate();
        return CollectionUtils.getLast(this.mergedEnd);
    }

    public int getFirstPosition() {
        if (this.isEmpty()) {
            throw new IllegalStateException("RegionSet is empty");
        }
        this.ensureMergedUpToDate();
        return this.mergedStart.get(0);
    }

    public RegionSet createInverted(String name, int lastPosition) {
        this.ensureMergedUpToDate();
        RegionSet inverted = new RegionSet(name);
        int lastPos = 0;
        int size = this.mergedStart.size();
        for (int i = 0; i < size; ++i) {
            if (this.mergedStart.get(i) > lastPos) {
                inverted.add(new Region(lastPos, this.mergedStart.get(i) - 1, name));
            }
            lastPos = this.mergedEnd.get(i) + 1;
        }
        if (lastPos <= lastPosition) {
            inverted.add(new Region(lastPos, lastPosition, name));
        }
        return inverted;
    }

    public boolean positionsEqual(RegionSet other) {
        if (other == null) {
            return false;
        }
        this.ensureMergedUpToDate();
        other.ensureMergedUpToDate();
        return ((Object)this.mergedStart).equals(other.mergedStart) && ((Object)this.mergedEnd).equals(other.mergedEnd);
    }

    public String toString() {
        return "{" + StringUtils.concat(this.inner, ",") + "}";
    }

    @Override
    public boolean add(Region o) {
        this.cleanSize = -1;
        return this.inner.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends Region> c) {
        this.cleanSize = -1;
        return this.inner.addAll(c);
    }

    @Override
    public void clear() {
        this.cleanSize = -1;
        this.inner.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.inner).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.inner).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public Iterator<Region> iterator() {
        return this.inner.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.cleanSize = -1;
        return this.inner.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cleanSize = -1;
        return this.inner.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cleanSize = -1;
        return this.inner.retainAll(c);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberComparator
    implements Comparator<Region> {
        private static final MemberComparator INSTANCE = new MemberComparator();

        private MemberComparator() {
        }

        @Override
        public int compare(Region region1, Region region2) {
            int startDiff = region1.getStart() - region2.getStart();
            if (startDiff != 0) {
                return startDiff;
            }
            int lengthDiff = region1.getLength() - region2.getLength();
            if (lengthDiff != 0) {
                return lengthDiff;
            }
            return region1.getOrigin().compareTo(region2.getOrigin());
        }

        static /* synthetic */ MemberComparator access$000() {
            return INSTANCE;
        }
    }
}

