/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.Arrays;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.assertion.PreconditionException;
import org.conqat.lib.commons.collections.ManagedIntArray;

public class LineOffsetConverter
extends ManagedIntArray {
    public LineOffsetConverter(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\n') {
                this.addArrayElement();
                this.array[this.size - 1] = i;
                continue;
            }
            if (chars[i] != '\r') continue;
            throw new PreconditionException("The string may not contain '\\r', but does so at position " + i);
        }
    }

    public int getOffset(int line) {
        CCSMPre.isTrue(1 <= line && line <= this.size + 1, "This is not a valid line: " + line);
        if (line == 1) {
            return 0;
        }
        return this.array[line - 2] + 1;
    }

    public int getLine(int offset) {
        CCSMPre.isTrue(offset >= 0, "Negative offsets not supported!");
        int index = Arrays.binarySearch(this.array, 0, this.size, offset);
        if (index >= 0) {
            return index + 1;
        }
        return -index;
    }
}

