/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

public class LineSplitter {
    private char[] characters;
    private int startIndex;
    private int length;

    public void setContent(String content) {
        this.characters = (char[])(content == null ? null : content.toCharArray());
        this.startIndex = 0;
        this.length = 0;
    }

    public String getNextLine() {
        if (this.characters == null) {
            return null;
        }
        this.startIndex += this.length;
        if (this.startIndex >= this.characters.length) {
            this.characters = null;
            return null;
        }
        int skip = 0;
        int i = this.startIndex;
        while (skip == 0 && i < this.characters.length) {
            char c = this.characters[i];
            ++i;
            if (c == '\n') {
                skip = 1;
            }
            if (c != '\r') continue;
            skip = 1;
            if (i >= this.characters.length || this.characters[i] != '\n') continue;
            skip = 2;
            ++i;
        }
        this.length = i - this.startIndex;
        return new String(this.characters, this.startIndex, this.length - skip);
    }
}

