/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.string.IRegexReplacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexReplacementProcessor {
    private final List<IRegexReplacement> expressions;

    public RegexReplacementProcessor(List<IRegexReplacement> expressions) {
        this.expressions = expressions;
    }

    public String process(String text) throws PatternSyntaxException {
        String result = text;
        for (IRegexReplacement expr : this.expressions) {
            Matcher matcher = expr.getPattern().matcher(result);
            String replacement = expr.getReplacement();
            try {
                result = matcher.replaceAll(replacement);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getMessage(), replacement, -1);
            }
        }
        return result;
    }
}

