/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.AllEqualComparator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IIdProvider;
import org.conqat.lib.commons.collections.IdComparator;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.reflect.MethodNameComparator;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepCloneTestUtils {
    private static final String DEEP_CLONE_METHOD_NAME = "deepClone";
    private static final String CLONE_METHOD_NAME = "clone";

    public static IdentityHashMap<Object, Object> buildCloneMap(Object orig, Object clone, Comparator<Object> comparator, String ... packagePrefixes) {
        IdentityHashMap<Object, Object> map = new IdentityHashMap<Object, Object>();
        DeepCloneTestUtils.buildCloneMap(orig, clone, map, comparator, packagePrefixes);
        return map;
    }

    public static <T> IdentityHashSet<T> getAllReferencedObjects(Object root, Class<T> type, String ... packagePrefixes) {
        IdentityHashSet<Object> result = new IdentityHashSet<Object>();
        for (Object object : DeepCloneTestUtils.getAllReferencedObjects(root, packagePrefixes)) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            Object object2 = object;
            result.add(object2);
        }
        return result;
    }

    public static IdentityHashSet<Object> getAllReferencedObjects(Object root, String ... packagePrefixes) {
        IdentityHashSet<Object> result = new IdentityHashSet<Object>();
        DeepCloneTestUtils.buildReferenceSet(root, result, packagePrefixes);
        return result;
    }

    public static <I extends Comparable<I>> IdentityHashMap<Object, Object> testDeepCloning(Object orig, Object clone, IIdProvider<I, Object> idProvider, String ... packagePrefixes) {
        IdentityHashMap<Object, Object> map = DeepCloneTestUtils.buildCloneMap(orig, clone, new IdComparator<I, Object>(idProvider), packagePrefixes);
        for (Object origObject : map.keySet()) {
            Object cloneObject = map.get(origObject);
            CCSMAssert.isTrue(orig.getClass().equals(clone.getClass()), "Objects " + origObject + " and " + cloneObject + " have different types.");
            if (origObject.getClass().isEnum()) continue;
            CCSMAssert.isFalse(origObject == cloneObject, "Objects " + origObject + " and " + cloneObject + " are same.");
            CCSMAssert.isFalse(map.values().contains(origObject), "Clone network contains original object: " + origObject);
            CCSMAssert.isFalse(map.keySet().contains(cloneObject), "Orig network contains clone object: " + origObject);
        }
        return map;
    }

    private static void buildCloneMap(Object orig, Object clone, IdentityHashMap<Object, Object> map, Comparator<Object> comparator, String ... packagePrefixes) {
        if (!orig.getClass().equals(clone.getClass())) {
            throw new RuntimeException("Objects " + orig + " and " + clone + " are of different tpye [orig: " + orig.getClass().getName() + "][clone:" + orig.getClass().getName() + "]");
        }
        map.put(orig, clone);
        ArrayList<Object> origRefObjects = DeepCloneTestUtils.getReferencedObjects(orig, comparator, packagePrefixes);
        ArrayList<Object> cloneRefObjects = DeepCloneTestUtils.getReferencedObjects(clone, comparator, packagePrefixes);
        if (origRefObjects.size() != cloneRefObjects.size()) {
            throw new RuntimeException("Objects " + orig + " and " + clone + " have unequal numbers of referenced objects [orig: " + origRefObjects + "][clone:" + cloneRefObjects + "]");
        }
        for (int i = 0; i < origRefObjects.size(); ++i) {
            Object key = origRefObjects.get(i);
            Object value = cloneRefObjects.get(i);
            if (map.containsKey(key)) {
                if (map.get(key) == value) continue;
                throw new RuntimeException("Object " + key + " appears to be cloned to " + map.get(key) + " and to " + value);
            }
            if (key == null) continue;
            DeepCloneTestUtils.buildCloneMap(key, value, map, comparator, packagePrefixes);
        }
    }

    private static void buildReferenceSet(Object object, IdentityHashSet<Object> set, String[] packagePrefixes) {
        set.add(object);
        for (Object item : DeepCloneTestUtils.getReferencedObjects(object, AllEqualComparator.OBJECT_INSTANCE, packagePrefixes)) {
            if (item == null || set.contains(item)) continue;
            DeepCloneTestUtils.buildReferenceSet(item, set, packagePrefixes);
        }
    }

    private static ArrayList<Object> getArrayObjects(Object object, Comparator<Object> comparator, String ... packagePrefixes) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Method method : object.getClass().getMethods()) {
            Object returnValue;
            if (method.getParameterTypes().length != 0 || !DeepCloneTestUtils.hasArrayReturnType(method, packagePrefixes) || (returnValue = DeepCloneTestUtils.invoke(object, method)) == null) continue;
            Object[] array = (Object[])returnValue;
            List<Object> list = Arrays.asList(array);
            Collections.sort(list, comparator);
            result.addAll(list);
        }
        return result;
    }

    private static ArrayList<Object> getCollectionObjects(Object object, Comparator<Object> comparator, String ... packagePrefixes) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Method method : object.getClass().getMethods()) {
            Object returnValue;
            if (method.getParameterTypes().length != 0 || !DeepCloneTestUtils.hasCollectionReturnType(method, packagePrefixes) || (returnValue = DeepCloneTestUtils.invoke(object, method)) == null) continue;
            Collection collection = (Collection)returnValue;
            List<Object> list = CollectionUtils.sort(collection, comparator);
            result.addAll(list);
        }
        return result;
    }

    private static ArrayList<Method> getMethods(Object object, String[] packagePrefixes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : object.getClass().getMethods()) {
            Class<?> returnType;
            if (method.getName().equals(CLONE_METHOD_NAME) || method.getName().equals(DEEP_CLONE_METHOD_NAME) || method.getParameterTypes().length > 0 || !StringUtils.startsWithOneOf((returnType = method.getReturnType()).getName(), packagePrefixes)) continue;
            methods.add(method);
        }
        Collections.sort(methods, MethodNameComparator.INSTANCE);
        return methods;
    }

    private static ArrayList<Object> getNonCollectionObjects(Object object, String ... packagePrefixes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Method method : DeepCloneTestUtils.getMethods(object, packagePrefixes)) {
            objects.add(DeepCloneTestUtils.invoke(object, method));
        }
        return objects;
    }

    private static ArrayList<Object> getReferencedObjects(Object object, Comparator<Object> comparator, String ... packagePrefixes) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> nonCollectionObjects = DeepCloneTestUtils.getNonCollectionObjects(object, packagePrefixes);
        result.addAll(nonCollectionObjects);
        ArrayList<Object> collectionObjects = DeepCloneTestUtils.getCollectionObjects(object, comparator, packagePrefixes);
        result.addAll(collectionObjects);
        ArrayList<Object> arrayObjects = DeepCloneTestUtils.getArrayObjects(object, comparator, packagePrefixes);
        result.addAll(arrayObjects);
        return result;
    }

    private static boolean hasArrayReturnType(Method method, String ... packagePrefixes) {
        Class<?> returnType = method.getReturnType();
        if (!returnType.isArray()) {
            return false;
        }
        Class<?> actualType = returnType.getComponentType();
        return StringUtils.startsWithOneOf(actualType.getName(), packagePrefixes);
    }

    private static boolean hasCollectionReturnType(Method method, String ... packagePrefixes) {
        Class<?> returnType = method.getReturnType();
        if (!Collection.class.isAssignableFrom(returnType)) {
            return false;
        }
        Type genericReturnType = method.getGenericReturnType();
        if (returnType == genericReturnType) {
            return false;
        }
        ParameterizedType type = (ParameterizedType)method.getGenericReturnType();
        Type typeArg = type.getActualTypeArguments()[0];
        if (!(typeArg instanceof Class)) {
            return false;
        }
        Class actualType = (Class)typeArg;
        return StringUtils.startsWithOneOf(actualType.getName(), packagePrefixes);
    }

    private static Object invoke(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

