/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.tree;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.tree.ITreeNodeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtils {
    public static <T, K> T createTree(Set<List<K>> paths, ITreeNodeHandler<T, K> handler) {
        T root = handler.createRoot();
        for (List<K> path : paths) {
            TreeUtils.insert(root, path, handler);
        }
        return root;
    }

    public static <T> T createTreeFromStrings(Set<String> paths, String separator, ITreeNodeHandler<T, String> handler) {
        T root = handler.createRoot();
        for (String pathDescriptor : paths) {
            String[] pathElements = pathDescriptor.split(separator);
            TreeUtils.insert(root, Arrays.asList(pathElements), handler);
        }
        return root;
    }

    private static <T, K> void insert(T node, List<K> path, ITreeNodeHandler<T, K> handler) {
        for (K pathElement : path) {
            node = handler.getOrCreateChild(node, pathElement);
        }
    }
}

