/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.treemap.IDrawingPattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CushionTreeMapRenderer
implements ITreeMapRenderer {
    private final double h;
    private final double f;

    public CushionTreeMapRenderer(double h, double f) {
        this.h = h;
        this.f = f;
    }

    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        for (ITreeMapNode<T> child : node.getChildren()) {
            this.render(child, graphics, this.h, new double[4]);
        }
    }

    private <T> void render(ITreeMapNode<T> node, Graphics2D g, double height, double[] coefs) {
        Rectangle2D rect = node.getLayoutRectangle();
        double[] myCoefs = this.addLocalParabola(height, coefs, rect);
        if (node.getChildren().isEmpty()) {
            this.renderCushion(rect, myCoefs, g, node.getColor(), node.getPatternColor(), node.getDrawingPattern());
        } else if (node.getChildren().size() == 1) {
            this.render(node.getChildren().get(0), g, height, coefs);
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.render(child, g, height * this.f, myCoefs);
            }
        }
    }

    private double[] addLocalParabola(double height, double[] coefs, Rectangle2D rect) {
        double[] myCoefs = new double[4];
        double x1 = rect.getMinX();
        double x2 = rect.getMaxX();
        double y1 = rect.getMinY();
        double y2 = rect.getMaxY();
        myCoefs[0] = coefs[0] - 4.0 * height / (x2 - x1);
        myCoefs[1] = coefs[1] + 4.0 * height * (x1 + x2) / (x2 - x1);
        myCoefs[2] = coefs[2] - 4.0 * height / (y2 - y1);
        myCoefs[3] = coefs[3] + 4.0 * height * (y1 + y2) / (y2 - y1);
        return myCoefs;
    }

    private void renderCushion(Rectangle2D rect, double[] coefs, Graphics2D g, Color baseColor, Color patternColor, IDrawingPattern drawingPattern) {
        double lx = 0.09759;
        double ly = 0.19518;
        double lz = 0.9759;
        int minX = (int)(rect.getMinX() + 0.5);
        int minY = (int)(rect.getMinY() + 0.5);
        int maxX = (int)(rect.getMaxX() + 0.5);
        int maxY = (int)(rect.getMaxY() + 0.5);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                double nx = -(2.0 * coefs[0] * ((double)x + 0.5) + coefs[1]);
                double ny = -(2.0 * coefs[2] * ((double)y + 0.5) + coefs[3]);
                double norm = Math.sqrt(nx * nx + ny * ny + 1.0);
                double cosa = (nx * 0.09759 + ny * 0.19518 + 0.9759) / norm;
                Color color = baseColor;
                if (drawingPattern != null && drawingPattern.isForeground(x, y)) {
                    color = patternColor;
                }
                g.setColor(this.shadeColor(color, 0.2 + 0.8 * Math.max(0.0, cosa)));
                g.drawLine(x, y, x, y);
            }
        }
    }

    private Color shadeColor(Color color, double luminance) {
        int base = 0;
        if ((luminance *= 2.0) > 1.0) {
            luminance = 2.0 - luminance;
            base = (int)(255.0 * (1.0 - luminance));
        }
        return new Color((int)((double)color.getRed() * luminance) + base, (int)((double)color.getGreen() * luminance) + base, (int)((double)color.getBlue() * luminance) + base);
    }
}

