/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTextRenderer
implements ITreeMapRenderer {
    private static final int TEXT_PADDING = 5;
    private final Color textColor;
    private final Pattern separationPattern;

    public NodeTextRenderer(Color textColor, Pattern separationPattern) {
        this.textColor = textColor;
        this.separationPattern = separationPattern;
    }

    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        if (node.getChildren().isEmpty()) {
            Rectangle2D nodeArea = node.getLayoutRectangle();
            if (this.enoughSpace(nodeArea)) {
                this.drawText(node.getText(), nodeArea, graphics);
            }
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.renderTreeMap(child, graphics);
            }
        }
    }

    private boolean enoughSpace(Rectangle2D nodeArea) {
        return nodeArea.getWidth() > 15.0 && nodeArea.getHeight() > 15.0;
    }

    private <T> void drawText(String text, Rectangle2D availableSpace, Graphics2D graphics) {
        String fittedText = this.clipTextToWidth(text, availableSpace.getWidth(), graphics);
        if (fittedText.length() < text.length()) {
            fittedText = fittedText + "...";
        }
        int x = (int)availableSpace.getCenterX() - this.actualWidth(fittedText, graphics) / 2;
        int y = (int)availableSpace.getCenterY() + this.actualHeight(fittedText, graphics) / 2;
        graphics.setColor(this.textColor);
        graphics.drawString(fittedText, x, y);
    }

    private String clipTextToWidth(String text, double width, Graphics2D graphics) {
        String[] parts;
        double availableWidth = width - 10.0;
        if (this.separationPattern != null && (double)this.actualWidth(text, graphics) > availableWidth && (parts = this.separationPattern.split(text)).length > 0) {
            text = parts[parts.length - 1];
        }
        if ((double)this.actualWidth(text, graphics) > availableWidth) {
            availableWidth -= (double)this.actualWidth("...", graphics);
        }
        while (text.length() > 0 && (double)this.actualWidth(text, graphics) > availableWidth) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private int actualWidth(String label, Graphics2D graphics) {
        return (int)this.actualBounds(label, graphics).getWidth();
    }

    private int actualHeight(String label, Graphics2D graphics) {
        return (int)this.actualBounds(label, graphics).getHeight();
    }

    private Rectangle2D actualBounds(String label, Graphics2D graphics) {
        return graphics.getFont().getStringBounds(label, graphics.getFontRenderContext());
    }
}

