/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.treemap.ITreeMapLayoutAlgorithm;
import org.conqat.lib.commons.treemap.ITreeMapNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTreeMapAlgorithm
implements ITreeMapLayoutAlgorithm {
    @Override
    public <T> void layout(ITreeMapNode<T> tree, Rectangle2D target) {
        tree.setLayoutRectangle(target);
        this.layoutChildren(tree);
    }

    private <T> void layoutChildren(ITreeMapNode<T> node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        Rectangle2D rect = node.getLayoutRectangle();
        double sum = node.getArea();
        double x = rect.getMinX();
        double y = rect.getMinY();
        if (rect.getWidth() > rect.getHeight()) {
            for (ITreeMapNode<T> child : node.getChildren()) {
                double width = rect.getWidth() * child.getArea() / sum;
                child.setLayoutRectangle(new Rectangle2D.Double(x, y, width, rect.getHeight()));
                this.layoutChildren(child);
                x += width;
            }
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                double height = rect.getHeight() * child.getArea() / sum;
                child.setLayoutRectangle(new Rectangle2D.Double(x, y, rect.getWidth(), height));
                this.layoutChildren(child);
                y += height;
            }
        }
    }
}

