/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.treemap.ITreeMapLayoutAlgorithm;
import org.conqat.lib.commons.treemap.ITreeMapNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripeTreeMapAlgorithm
implements ITreeMapLayoutAlgorithm {
    @Override
    public <T> void layout(ITreeMapNode<T> tree, Rectangle2D target) {
        tree.setLayoutRectangle(target);
        this.layoutChildren(tree);
    }

    private <T> void layoutChildren(ITreeMapNode<T> node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        Rectangle2D rect = node.getLayoutRectangle();
        double scale = rect.getWidth() * rect.getHeight() / node.getArea();
        double layoutX = rect.getMinX();
        double lastX = 0.0;
        ArrayList<ITreeMapNode<T>> l = new ArrayList<ITreeMapNode<T>>();
        ArrayList<ITreeMapNode<T>> lastList = new ArrayList<ITreeMapNode<T>>();
        for (ITreeMapNode<T> child : node.getChildren()) {
            double oldAspect = this.calcAvgAspect(l, rect.getHeight(), scale);
            l.add(child);
            double newAspect = this.calcAvgAspect(l, rect.getHeight(), scale);
            if (!(oldAspect < newAspect)) continue;
            l.remove(l.size() - 1);
            lastX = layoutX;
            lastList.clear();
            lastList.addAll(l);
            layoutX += this.layoutList(l, rect.getHeight(), layoutX, rect.getMinY(), scale);
            l.clear();
            l.add(child);
        }
        lastList.addAll(l);
        if (this.calcAvgAspect(lastList, rect.getHeight(), scale) < this.calcAvgAspect(l, rect.getHeight(), scale)) {
            this.layoutList(lastList, rect.getHeight(), lastX, rect.getMinY(), scale);
        } else {
            this.layoutList(l, rect.getHeight(), layoutX, rect.getMinY(), scale);
        }
    }

    private <T> double calcAvgAspect(List<ITreeMapNode<T>> l, double layoutHeight, double areaScale) {
        if (l.isEmpty()) {
            return 1.0E8;
        }
        double area = 0.0;
        for (ITreeMapNode<T> node : l) {
            area += node.getArea();
        }
        double layoutWidth = area * areaScale / layoutHeight;
        double aspectSum = 0.0;
        for (ITreeMapNode<T> node : l) {
            double localHeight = node.getArea() * areaScale / layoutWidth;
            double localAspect = Math.max(layoutWidth / localHeight, localHeight / layoutWidth);
            aspectSum += localAspect;
        }
        return aspectSum / (double)l.size();
    }

    private <T> double layoutList(List<ITreeMapNode<T>> l, double layoutHeight, double layoutX, double layoutY, double areaScale) {
        double nodeArea = 0.0;
        for (ITreeMapNode<T> node : l) {
            nodeArea += node.getArea();
        }
        double layoutWidth = nodeArea * areaScale / layoutHeight;
        for (ITreeMapNode<T> node : l) {
            double nodeHeight = node.getArea() * areaScale / layoutWidth;
            node.setLayoutRectangle(new Rectangle2D.Double(layoutX, layoutY, layoutWidth, nodeHeight));
            layoutY += nodeHeight;
            this.layoutChildren(node);
        }
        return layoutWidth;
    }
}

