/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    NSMenu nsMenu;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean visible;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;
    static final int GAP = 4;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget();
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean bl) {
        if ((this.style & 6) != 0) {
            return;
        }
        TrayItem trayItem = this.display.currentTrayItem;
        if (trayItem != null && bl) {
            trayItem.showMenu(this);
            return;
        }
        if (bl) {
            NSObject nSObject;
            Shell shell = this.getShell();
            NSWindow nSWindow = shell.view.window();
            NSPoint nSPoint = null;
            if (this.hasLocation) {
                nSObject = nSWindow.contentView();
                Point point = this.display.map(null, (Control)shell, new Point(this.x, this.y));
                nSPoint = new NSPoint();
                double d = nSWindow.userSpaceScaleFactor();
                nSPoint.x = (double)point.x * d;
                nSPoint.y = (((NSView)nSObject).frame().height - (double)point.y) * d;
            } else {
                nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
            }
            nSWindow.retain();
            nSObject = NSEvent.otherEventWithType(15L, nSPoint, 0L, 0.0, nSWindow.windowNumber(), nSWindow.graphicsContext(), (short)0, 0L, 0L);
            NSMenu.popUpContextMenu(this.nsMenu, (NSEvent)nSObject, shell.view);
            nSWindow.release();
        } else {
            this.nsMenu.cancelTracking();
        }
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        NSMenu nSMenu = (NSMenu)new SWTMenu().alloc();
        nSMenu = nSMenu.initWithTitle(NSString.string());
        nSMenu.setAutoenablesItems(false);
        nSMenu.setDelegate(nSMenu);
        this.nsMenu = nSMenu;
    }

    void createItem(MenuItem menuItem, int n) {
        NSApplication nSApplication;
        NSMenu nSMenu;
        Object object;
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        NSMenuItem nSMenuItem = null;
        if ((menuItem.style & 2) != 0) {
            nSMenuItem = NSMenuItem.separatorItem();
            nSMenuItem.retain();
        } else {
            nSMenuItem = (NSMenuItem)new SWTMenuItem().alloc();
            object = NSString.string();
            nSMenuItem.initWithTitle((NSString)object, 0L, (NSString)object);
            nSMenuItem.setTarget(nSMenuItem);
            nSMenuItem.setAction(OS.sel_sendSelection);
        }
        menuItem.nsItem = nSMenuItem;
        menuItem.createJNIRef();
        menuItem.register();
        this.nsMenu.insertItem(nSMenuItem, n);
        if (this.itemCount == this.items.length) {
            object = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = menuItem;
        object = menuItem.createEmptyMenu();
        if (object != null) {
            nSMenuItem.setSubmenu((NSMenu)object);
            ((NSObject)object).release();
        }
        if (this.display.menuBar == this && (nSMenu = (nSApplication = this.display.application).mainMenu()) != null) {
            nSMenuItem.setMenu(null);
            nSMenu.insertItem(nSMenuItem, n + 1);
        }
        if (!this.getEnabled()) {
            nSMenuItem.setEnabled(false);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsMenu);
    }

    void destroyItem(MenuItem menuItem) {
        NSApplication nSApplication;
        NSMenu nSMenu;
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == menuItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.nsMenu.removeItem(menuItem.nsItem);
        if (this.display.menuBar == this && (nSMenu = (nSApplication = this.display.application).mainMenu()) != null) {
            NSMenuItem nSMenuItem = menuItem.nsItem;
            nSMenu.removeItem(nSMenuItem);
        }
    }

    void fixMenus(Decorations decorations) {
        this.parent = decorations;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] menuItemArray = new MenuItem[this.itemCount];
        int n = 0;
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.itemCount) {
                MenuItem menuItem = this.items[n2];
                if (menuItem != null && !menuItem.isDisposed()) {
                    menuItemArray[n++] = menuItem;
                }
                ++n2;
            }
        }
        if (n != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                string = String.valueOf(string) + menuItemArray[n2].getNameText() + ", ";
                ++n2;
            }
            string = String.valueOf(string) + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] menuArray = this.display.popups;
            if (menuArray == null) {
                return false;
            }
            int n = 0;
            while (n < menuArray.length) {
                if (menuArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        return this.visible;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == menuItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void menu_willHighlightItem(long l, long l2, long l3, long l4) {
        Widget widget = this.display.getWidget(l4);
        if (widget instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)widget;
            menuItem.sendEvent(30);
        }
    }

    void menuNeedsUpdate(long l, long l2, long l3) {
    }

    void menuWillOpen(long l, long l2, long l3) {
        Object object;
        MenuItem menuItem;
        this.visible = true;
        this.sendEvent(22);
        if (this.isDisposed()) {
            return;
        }
        double d = 0.0;
        NSAttributedString[] nSAttributedStringArray = new NSAttributedString[this.itemCount];
        int n = 0;
        while (n < this.itemCount) {
            menuItem = this.items[n];
            NSMenuItem nSMenuItem = menuItem.nsItem;
            nSAttributedStringArray[n] = nSMenuItem.attributedTitle();
            object = nSMenuItem.image();
            double d2 = 4.0;
            if (nSAttributedStringArray[n] != null) {
                d2 += nSAttributedStringArray[n].size().width;
            }
            if (object != null) {
                d2 += ((NSImage)object).size().width + 4.0;
            }
            if (nSAttributedStringArray[n] != null) {
                d = Math.max(d, d2);
            }
            ++n;
        }
        n = 0;
        while (n < this.itemCount) {
            int n2;
            int n3;
            menuItem = this.items[n];
            if (!menuItem.updateAccelerator(true) && menuItem.accelerator == 0 && nSAttributedStringArray[n] != null && (this.style & 2) == 0 && (menuItem.style & 0x40) == 0 && (n3 = menuItem.text.indexOf(9)) != -1 && (n2 = ((String)(object = menuItem.text.substring(n3))).length()) > 1) {
                NSMenuItem nSMenuItem = menuItem.nsItem;
                NSImage nSImage = nSMenuItem.image();
                double d3 = d;
                if (nSImage != null) {
                    d3 -= nSImage.size().width + 4.0;
                }
                NSMutableAttributedString nSMutableAttributedString = new NSMutableAttributedString(nSAttributedStringArray[n].mutableCopy());
                NSString nSString = (NSString)new NSString().alloc();
                nSString = nSString.initWithString((String)object);
                NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(1L);
                nSMutableDictionary.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
                NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSMutableDictionary);
                nSMutableDictionary.release();
                nSString.release();
                nSMutableAttributedString.appendAttributedString(nSAttributedString);
                nSAttributedString.release();
                NSRange nSRange = new NSRange();
                nSRange.length = nSMutableAttributedString.length();
                NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
                nSMutableParagraphStyle.setTabStops(NSArray.array());
                NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
                nSTextTab = nSTextTab.initWithType(0L, d3);
                nSMutableParagraphStyle.addTabStop(nSTextTab);
                nSTextTab.release();
                nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
                nSMutableParagraphStyle.release();
                nSMenuItem.setAttributedTitle(nSMutableAttributedString);
                nSMutableAttributedString.release();
            }
            ++n;
        }
    }

    void menuDidClose(long l, long l2, long l3) {
        this.sendEvent(23);
        if (this.isDisposed()) {
            return;
        }
        this.visible = false;
        int n = 0;
        while (n < this.itemCount) {
            MenuItem menuItem = this.items[n];
            menuItem.updateAccelerator(false);
            if ((menuItem.style & 2) == 0) {
                menuItem.updateText();
            }
            ++n;
        }
    }

    void register() {
        super.register();
        this.display.addWidget(this.nsMenu, this);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                MenuItem menuItem = this.items[n];
                if (menuItem != null && !menuItem.isDisposed()) {
                    menuItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsMenu != null) {
            this.nsMenu.release();
        }
        this.nsMenu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void reskinChildren(int n) {
        MenuItem[] menuItemArray = this.getItems();
        int n2 = 0;
        while (n2 < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.reskin(n);
            ++n2;
        }
        super.reskinChildren(n);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem != null && menuItem.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = menuItem;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        int n = 0;
        while (n < this.items.length) {
            MenuItem menuItem = this.items[n];
            if (menuItem != null) {
                menuItem.nsItem.setEnabled(bl && menuItem.getEnabled());
            }
            ++n;
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
        }
    }
}

