/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguageConstants;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IStatementOracle;
import org.conqat.lib.scanner.StatementOracle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ELanguage {
    JAVA(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, true, "java"),
    CPP(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, true, "cpp", "cc", "c", "h", "hh", "hpp"),
    VB(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.COLON, ETokenType.EOL}), CollectionUtils.asHashSet((Object[])new String[]{"'"}), false, "vb", "frm", "cls", "bas"),
    PL1(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, false, "pl1", "pli"),
    COBOL(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.DOT, ETokenType.EOL}), CollectionUtils.asHashSet((Object[])new String[]{"/", "*"}), false, "cbl", "cob", "cobol"),
    CS(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), CollectionUtils.asHashSet((Object[])new String[]{"///", "//", "/*", "*/"}), true, "cs"),
    ABAP(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.DOT}), CollectionUtils.asHashSet((Object[])new String[]{"*", "\""}), false, "abap"),
    ADA(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.THEN}), CollectionUtils.asHashSet((Object[])new String[]{"--"}), false, "ada", "ads", "adb"),
    TEXT(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.DOT, ETokenType.QUESTION, ETokenType.EXCLAMATION, ETokenType.COLON, ETokenType.COMMA, ETokenType.MULTIPLE_EOL}), Collections.<String>emptySet(), false, "txt"),
    XML(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET}), CollectionUtils.asHashSet((Object[])new String[]{"<!--", "-->"}), true, "xml", "xsl", "xslt"),
    PLSQL(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON}), CollectionUtils.asHashSet((Object[])new String[]{"/*", "*/", "--"}), false, "sql", "pks", "pkb"),
    PYTHON(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), CollectionUtils.asHashSet((Object[])new String[]{"#"}), false, "py"),
    TSQL(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL}), CollectionUtils.asHashSet((Object[])new String[]{"/*", "*/", "--"}), false, "tsql"),
    MATLAB(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON}), CollectionUtils.asHashSet((Object[])new String[]{"%"}), true, "m"),
    PHP(CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE}), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, true, "php", "php4", "php5");

    private static HashMap<String, ELanguage> extension2LanguageMap;
    private final IStatementOracle statementOracle;
    private final String[] extensions;
    private Set<String> commentDelimiters;
    private final boolean caseSensitive;

    private ELanguage(Set<ETokenType> statementDelimiters, Set<String> commentDelimiters, boolean caseSensitive, String ... extensions) {
        this.statementOracle = new StatementOracle(statementDelimiters);
        this.commentDelimiters = commentDelimiters;
        this.caseSensitive = caseSensitive;
        this.extensions = extensions;
    }

    public String[] getFileExtensions() {
        return (String[])CollectionUtils.copyArray((Object[])this.extensions);
    }

    public IStatementOracle getStatementOracle() {
        return this.statementOracle;
    }

    public static ELanguage fromFileExtension(String path) {
        return ELanguage.fromFileExtension(new File(path));
    }

    public static ELanguage fromFileExtension(File file) {
        String extension = FileSystemUtils.getFileExtension((File)file);
        if (extension == null) {
            throw new IllegalArgumentException("Filename has no extension");
        }
        ELanguage result = extension2LanguageMap.get(extension.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("Extension '" + extension + "' unknown");
        }
        return result;
    }

    public String getCommentContent(String commentText) {
        String[] lines;
        StringBuffer content = new StringBuffer();
        for (String line : lines = StringUtils.splitLines((String)commentText)) {
            if (content.length() > 0) {
                content.append(StringUtils.CR);
            }
            for (String delimiter : this.commentDelimiters) {
                line = line.trim();
                line = StringUtils.stripPrefix((String)delimiter, (String)line);
                line = StringUtils.stripSuffix((String)delimiter, (String)line);
                line = line.trim();
            }
            content.append(line);
        }
        return content.toString();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    static {
        extension2LanguageMap = new HashMap();
        for (ELanguage language : ELanguage.values()) {
            for (String extension : language.extensions) {
                CCSMAssert.isFalse((boolean)extension2LanguageMap.containsKey(extension.toLowerCase()), (String)("Duplicate extension " + extension));
                extension2LanguageMap.put(extension.toLowerCase(), language);
            }
        }
    }
}

