/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.conqat.lib.scanner.ABAPScanner;
import org.conqat.lib.scanner.AdaScanner;
import org.conqat.lib.scanner.CPPScanner;
import org.conqat.lib.scanner.CSScanner;
import org.conqat.lib.scanner.CobolScanner;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.JavaScanner;
import org.conqat.lib.scanner.MatlabScanner;
import org.conqat.lib.scanner.PHPScanner;
import org.conqat.lib.scanner.PL1Scanner;
import org.conqat.lib.scanner.PLSQLScanner;
import org.conqat.lib.scanner.PythonScanner;
import org.conqat.lib.scanner.StrictScanner;
import org.conqat.lib.scanner.TSQLScanner;
import org.conqat.lib.scanner.TextScanner;
import org.conqat.lib.scanner.VBScanner;
import org.conqat.lib.scanner.XMLScanner;

public class ScannerFactory {
    private ScannerFactory() {
    }

    public static IScanner newScanner(ELanguage language, File file) throws IOException {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, file));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, File file) throws IOException {
        return ScannerFactory.newLenientScanner(language, new FileReader(file), file.getCanonicalPath());
    }

    public static IScanner newScanner(ELanguage language, String input, String originId) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, input, originId));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, String input, String originId) {
        return ScannerFactory.newLenientScanner(language, new StringReader(input), originId);
    }

    public static IScanner newScanner(ELanguage language, Reader reader, String originId) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, reader, originId));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, Reader reader, String originId) {
        switch (language) {
            case JAVA: {
                return new JavaScanner(reader, originId);
            }
            case CS: {
                return new CSScanner(reader, originId);
            }
            case CPP: {
                return new CPPScanner(reader, originId);
            }
            case VB: {
                return new VBScanner(reader, originId);
            }
            case PL1: {
                return new PL1Scanner(reader, originId);
            }
            case COBOL: {
                return new CobolScanner(reader, originId);
            }
            case ABAP: {
                return new ABAPScanner(reader, originId);
            }
            case ADA: {
                return new AdaScanner(reader, originId);
            }
            case TEXT: {
                return new TextScanner(reader, originId);
            }
            case XML: {
                return new XMLScanner(reader, originId);
            }
            case PLSQL: {
                return new PLSQLScanner(reader, originId);
            }
            case PYTHON: {
                return new PythonScanner(reader, originId);
            }
            case TSQL: {
                return new TSQLScanner(reader, originId);
            }
            case MATLAB: {
                return new MatlabScanner(reader, originId);
            }
            case PHP: {
                return new PHPScanner(reader, originId);
            }
        }
        throw new IllegalArgumentException("Language '" + (Object)((Object)language) + "' not supported.");
    }

    public static IScanner strict(ILenientScanner scanner) {
        return new StrictScanner(scanner);
    }
}

