/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.XMLToken;

class XMLScanner
implements ILenientScanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int CONTENT = 4;
    public static final int DOCTYPEDECL = 2;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0004\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0012\u0001\u0010\u0001\r\u0002\u0000\u0001\u000b\u0001\u0011\u0005\u0000\u0001\u0006\u0001\u0007\u0001\u0019\n\b\u0001\u0005\u0001\f\u0001\t\u0001\u001a\u0001\n\u0001\u001b\u0001\u0000\u0001\u0016\u0001\u000f\u0001\u0014\u0001\u0015\u0002\u000f\r\u0005\u0001\u0017\u0006\u0005\u0001\u0013\u0001\u0000\u0001\u0018\u0001\u0000\u0001\u0005\u0001\u0000\u0006\u000f\u0011\u0005\u0001\u000e\u0002\u0005<\u0000\u0001\u0007\b\u0000\u0017\u0005\u0001\u0000\u001f\u0005\u0001\u0000\u0208\u0005p\u0007\u000e\u0005\u0001\u0000\u1c81\u0005\f\u0000\u0002\u00051\u0000\u0002\u0007/\u0000\u0120\u0005\u0a70\u0000\u03f0\u0005\u0011\u0000\ua7ff\u0005\u2100\u0000\u04d0\u0005 \u0000\u020e\u0005\u0002\u0000";
    private static final char[] ZZ_CMAP = XMLScanner.zzUnpackCMap("\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0004\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0012\u0001\u0010\u0001\r\u0002\u0000\u0001\u000b\u0001\u0011\u0005\u0000\u0001\u0006\u0001\u0007\u0001\u0019\n\b\u0001\u0005\u0001\f\u0001\t\u0001\u001a\u0001\n\u0001\u001b\u0001\u0000\u0001\u0016\u0001\u000f\u0001\u0014\u0001\u0015\u0002\u000f\r\u0005\u0001\u0017\u0006\u0005\u0001\u0013\u0001\u0000\u0001\u0018\u0001\u0000\u0001\u0005\u0001\u0000\u0006\u000f\u0011\u0005\u0001\u000e\u0002\u0005<\u0000\u0001\u0007\b\u0000\u0017\u0005\u0001\u0000\u001f\u0005\u0001\u0000\u0208\u0005p\u0007\u000e\u0005\u0001\u0000\u1c81\u0005\f\u0000\u0002\u00051\u0000\u0002\u0007/\u0000\u0120\u0005\u0a70\u0000\u03f0\u0005\u0011\u0000\ua7ff\u0005\u2100\u0000\u04d0\u0005 \u0000\u020e\u0005\u0002\u0000");
    private static final int[] ZZ_ACTION = XMLScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0002\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0003\u0002\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u0001\u0001\u000f\u0001\u0000\u0001\u0001\u0005\u0000\u0001\u0010\b\u0000\u0001\u0005\u001a\u0000\u0001\u0011\u0005\u0000";
    private static final int[] ZZ_ROWMAP = XMLScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001c\u00008\u0000T\u0000p\u0000T\u0000T\u0000\u008c\u0000\u00a8\u0000T\u0000\u00c4\u0000\u00e0\u0000\u00fc\u0000T\u0000T\u0000T\u0000T\u0000T\u0000T\u0000T\u0000\u0118\u0000\u0134\u0000\u0150\u0000\u016c\u0000\u0188\u0000\u01a4\u0000\u01c0\u0000\u00e0\u0000\u01dc\u0000T\u0000\u00fc\u0000\u01f8\u0000\u0214\u0000\u0230\u0000\u024c\u0000\u0268\u0000\u0284\u0000\u02a0\u0000T\u0000\u02bc\u0000\u02d8\u0000\u02f4\u0000\u0310\u0000\u032c\u0000\u0348\u0000\u0364\u0000\u0380\u0000\u039c\u0000\u03b8\u0000\u03d4\u0000\u03f0\u0000\u040c\u0000\u0428\u0000\u0444\u0000\u0460\u0000\u047c\u0000\u0498\u0000\u04b4\u0000\u04d0\u0000\u04ec\u0000\u0508\u0000\u0524\u0000\u0540\u0000\u055c\u0000\u0578\u0000T\u0000\u0594\u0000\u05b0\u0000\u05cc\u0000\u05e8\u0000\u0604";
    private static final int[] ZZ_TRANS = XMLScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0004\u0001\u0005\u0002\u0006\u0001\u0007\u0001\b\u0003\u0004\u0001\t\u0001\n\u0001\u000b\u0002\u0004\u0002\b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0004\b\u0001\u0004\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0004\u0001\u0005\u0002\u0006\u0001\u0007\u0001\b\u0003\u0004\u0001\t\u0001\u0013\u0001\u000b\u0002\u0004\u0002\b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0004\b\u0001\u0014\u0001\u0010\u0001\u0011\u0001\u0012\t\u0015\u0001\u0016\u0001\u0015\u0001\u0017\u0005\u0015\u0001\u0018\n\u0015\u001e\u0000\u0001\u0006\u001e\u0000\u0004\b\u0005\u0000\u0002\b\u0004\u0000\u0004\b\u0016\u0000\u0001\u0019\u000e\u0000\u0001\u001a\u0007\u0000\u0001\u001b\u0002\u001a\u0004\u0000\u0004\u001a\u0004\u0000\t\u001c\u0001\u0000\u0001\u001c\u0001\u001d\u0004\u001c\u0001\u001e\u000b\u001c\t\u001f\u0001\u0000\u0001\u001f\u0001 \u0005\u001f\u0001\u001e\n\u001f\t\u0015\u0001!\u0001\u0015\u0001\u0017\u0005\u0015\u0001\u0018\n\u0015\u0012\u0000\u0001\"\u000e\u0000\u0001#\u0007\u0000\u0001$\u0002#\u0004\u0000\u0004#\u0004\u0000\t\u0015\u0001%\u0001\u0015\u0001\u0017\u0005\u0015\u0001\u0018\n\u0015\u0006\u0000\u0001&\u001a\u0000\u0004\u001a\u0003\u0000\u0001'\u0001\u0000\u0002\u001a\u0004\u0000\u0004\u001a\f\u0000\u0001(\u0005\u0000\u0001)\u0012\u0000\u0001*\u0007\u0000\u0001+\u0002*\u0004\u0000\u0004*\t\u0000\u0001,\u0007\u0000\u0001-\u0002,\u0004\u0000\u0004,\u0016\u0000\u0001.\u000f\u0000\u0001&\f\u0000\u0001/\r\u0000\u0004#\u0003\u0000\u0001\u0015\u0001\u0000\u0002#\u0004\u0000\u0004#\f\u0000\u00010\u0005\u0000\u00011\u001e\u0000\u00012\u0001.\u000f\u0000\u00013\u001d\u0000\u0001(\u0003\u0000\u0001'\u0017\u0000\u00014\u0006\u0000\u00014\u0004\u0000\u00034\n\u0000\u0004*\u0003\u0000\u0001\u001c\u0001\u0000\u0002*\u0004\u0000\u0004*\f\u0000\u00015\u0005\u0000\u00016\u0012\u0000\u0004,\u0003\u0000\u0001\u001f\u0001\u0000\u0002,\u0004\u0000\u0004,\f\u0000\u00017\u0005\u0000\u00018 \u0000\u0001/\u001c\u0000\u00019\u000f\u0000\u00010\u0003\u0000\u0001\u0015\u0017\u0000\u0001:\u0006\u0000\u0001:\u0004\u0000\u0003:\n\u0000\u0001;\b\u0000\u0002;\u0004\u0000\u0004;\u0004\u0000\u00063\u0001<\u00153\b\u0000\u00014\u0003\u0000\u0001'\u0002\u0000\u00014\u0004\u0000\u00034\r\u0000\u00015\u0003\u0000\u0001\u001c\u0017\u0000\u0001=\u0006\u0000\u0001=\u0004\u0000\u0003=\r\u0000\u00017\u0003\u0000\u0001\u001f\u0017\u0000\u0001>\u0006\u0000\u0001>\u0004\u0000\u0003>\u001a\u0000\u0001?\u000e\u0000\u0001:\u0003\u0000\u0001\u0015\u0002\u0000\u0001:\u0004\u0000\u0003:\n\u0000\u0004;\u0005\u0000\u0002;\u0004\u0000\u0004;\u0004\u0000\u00063\u0001@\u00153\b\u0000\u0001=\u0003\u0000\u0001\u001c\u0002\u0000\u0001=\u0004\u0000\u0003=\r\u0000\u0001>\u0003\u0000\u0001\u001f\u0002\u0000\u0001>\u0004\u0000\u0003>\u001b\u0000\u0001A\u000f\u0000\u0001B(\u0000\u0001C\u001a\u0000\u0001D\u0018\u0000\u0001E\b\u0000\u0018E\u0001F\u001bE\u0001G\rE\u0001\u0015\rE\u0001G\u0003E";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = XMLScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0002\u0001\u0001\t\u0003\u0001\u0007\t\u0002\u0001\u0001\u0000\u0001\u0001\u0005\u0000\u0001\t\b\u0000\u0001\t\u001a\u0000\u0001\t\u0005\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private StringBuffer string = new StringBuffer();
    private String originId;

    private static int[] zzUnpackAction() {
        int[] result = new int[71];
        int offset = 0;
        offset = XMLScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[71];
        int offset = 0;
        offset = XMLScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[1568];
        int offset = 0;
        offset = XMLScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[71];
        int offset = 0;
        offset = XMLScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void reset(Reader reader, String originId) {
        this.originId = originId;
        this.yyreset(reader);
    }

    public void close() throws IOException {
        this.yyclose();
    }

    XMLScanner(Reader in, String originId) {
        this.originId = originId;
        this.zzReader = in;
    }

    XMLScanner(InputStream in, String originId) {
        this(new InputStreamReader(in), originId);
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 142) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public XMLToken getNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block40: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block41: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block41;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block41;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block41;
                        }
                        ++this.yyline;
                        continue block41;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 5: {
                    return new XMLToken(ETokenType.XML_NAME, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 18: {
                    continue block40;
                }
                case 2: {
                    return new XMLToken(ETokenType.ILLEGAL_CHARACTER, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 19: {
                    continue block40;
                }
                case 6: {
                    return new XMLToken(ETokenType.LEFT_ANGLE_BRACKET, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 20: {
                    continue block40;
                }
                case 3: 
                case 21: {
                    continue block40;
                }
                case 12: {
                    return new XMLToken(ETokenType.QUESTION, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 22: {
                    continue block40;
                }
                case 7: {
                    this.yybegin(4);
                    return new XMLToken(ETokenType.RIGHT_ANGLE_BRACKET, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 23: {
                    continue block40;
                }
                case 4: {
                    --this.yyline;
                }
                case 24: {
                    continue block40;
                }
                case 11: {
                    return new XMLToken(ETokenType.EQ, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 25: {
                    continue block40;
                }
                case 1: {
                    this.yybegin(0);
                    if (!StringUtils.isEmpty((String)this.yytext())) {
                        return new XMLToken(ETokenType.STRING_LITERAL, this.yychar, this.yyline, this.yytext(), this.originId);
                    }
                }
                case 26: {
                    continue block40;
                }
                case 15: {
                    this.yybegin(0);
                    return new XMLToken(ETokenType.LEFT_ANGLE_BRACKET, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 27: {
                    continue block40;
                }
                case 9: {
                    this.yybegin(2);
                    return new XMLToken(ETokenType.LBRACK, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 28: {
                    continue block40;
                }
                case 10: {
                    return new XMLToken(ETokenType.SLASH, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 29: {
                    continue block40;
                }
                case 13: {
                    return new XMLToken(ETokenType.RIGHT_ANGLE_BRACKET, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 30: {
                    continue block40;
                }
                case 17: {
                    return new XMLToken(ETokenType.TRADITIONAL_COMMENT, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 31: {
                    continue block40;
                }
                case 16: {
                    return new XMLToken(ETokenType.STRING_LITERAL, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 32: {
                    continue block40;
                }
                case 14: {
                    this.yybegin(0);
                    return new XMLToken(ETokenType.RBRACK, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 33: {
                    continue block40;
                }
                case 8: {
                    return new XMLToken(ETokenType.EXCLAMATION, this.yychar, this.yyline, this.yytext(), this.originId);
                }
                case 34: {
                    continue block40;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return new XMLToken(ETokenType.EOF, this.yychar, this.yyline, this.yytext(), this.originId);
            }
            this.zzScanError(1);
        }
    }
}

