/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    NSPrinter printer;
    NSPrintInfo printInfo;
    NSPrintOperation operation;
    NSView view;
    NSWindow window;
    boolean isGCCreated;
    static final String DRIVER = "Mac";

    public static PrinterData[] getPrinterList() {
        PrinterData[] printerDataArray;
        block4: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSArray nSArray = NSPrinter.printerNames();
                int n = nSArray.count();
                PrinterData[] printerDataArray2 = new PrinterData[n];
                int n2 = 0;
                while (n2 < n) {
                    NSString nSString = new NSString(nSArray.objectAtIndex(n2));
                    printerDataArray2[n2] = new PrinterData(DRIVER, nSString.getString());
                    ++n2;
                }
                printerDataArray = printerDataArray2;
                Object var6_7 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_8 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData printerData;
        block6: {
            NSPrinter nSPrinter;
            NSAutoreleasePool nSAutoreleasePool;
            block4: {
                block5: {
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        nSPrinter = NSPrintInfo.defaultPrinter();
                        if (nSPrinter != null) break block4;
                        Object var3_2 = null;
                        if (nSAutoreleasePool == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var3_4 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return null;
            }
            NSString nSString = nSPrinter.name();
            printerData = new PrinterData(DRIVER, nSString.getString());
            Object var3_3 = null;
            if (nSAutoreleasePool == null) break block6;
            nSAutoreleasePool.release();
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize nSSize = this.printInfo.paperSize();
                NSRect nSRect = this.printInfo.imageablePageBounds();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                float f = this.scalingFactor();
                n = (int)((float)n - nSRect.x * (float)point.x / (float)point2.x / f);
                n2 = (int)((float)n2 - nSRect.y * (float)point.y / (float)point2.y / f);
                n3 = (int)((float)n3 + (nSSize.width - nSRect.width) * (float)point.x / (float)point2.x / f);
                n4 = (int)((float)n4 + (nSSize.height - nSRect.height) * (float)point.y / (float)point2.y / f);
                rectangle = new Rectangle(n, n2, n3, n4);
                Object var11_12 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var11_13 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    /*
     * Exception decompiling
     */
    protected void create(DeviceData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 497->501)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void destroy() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        block6: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                if (gCData != null) {
                    if (this.isGCCreated) {
                        SWT.error(5);
                    }
                    gCData.device = this;
                    gCData.background = this.getSystemColor((int)1).handle;
                    gCData.foreground = this.getSystemColor((int)2).handle;
                    gCData.font = this.getSystemFont();
                    float f = this.scalingFactor();
                    Point point = this.getDPI();
                    Point point2 = this.getIndependentDPI();
                    NSSize nSSize = this.printInfo.paperSize();
                    nSSize.width = nSSize.width * (float)(point.x / point2.x) / f;
                    nSSize.height = nSSize.height * (float)point.y / (float)point2.y / f;
                    gCData.size = nSSize;
                    this.isGCCreated = true;
                }
                this.createContext();
                n = this.operation.context().id;
                Object var7_8 = null;
                if (nSAutoreleasePool == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_9 = null;
                    if (nSAutoreleasePool == null) break block7;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    protected void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 49->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        super.release();
    }

    float scalingFactor() {
        NSNumber nSNumber = new NSNumber(this.printInfo.dictionary().objectForKey(OS.NSPrintScalingFactor));
        return OS.PTR_SIZEOF == 4 ? nSNumber.floatValue() : (float)nSNumber.doubleValue();
    }

    public boolean startJob(String string) {
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                block6: {
                    this.checkDevice();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        if (string != null && string.length() != 0) {
                            this.operation.setJobTitle(NSString.stringWith(string));
                        }
                        if (!this.createContext()) break block5;
                        this.view.beginDocument();
                        Object var3_3 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var3_5 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return true;
            }
            Object var3_4 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return false;
    }

    boolean createContext() {
        if (this.operation.context() != null) {
            return true;
        }
        this.printInfo.setUpPrintOperationDefaultValues();
        NSPrintOperation.setCurrentOperation(this.operation);
        return this.operation.createContext() != null;
    }

    /*
     * Exception decompiling
     */
    public void endJob() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cancelJob() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 63->67)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public boolean startPage() {
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float f = this.scalingFactor();
                NSSize nSSize = this.printInfo.paperSize();
                nSSize.width /= f;
                nSSize.height /= f;
                NSRect nSRect = new NSRect();
                nSRect.width = nSSize.width;
                nSRect.height = nSSize.height;
                this.view.beginPageInRect(nSRect, new NSPoint());
                NSRect nSRect2 = this.printInfo.imageablePageBounds();
                nSRect2.x /= f;
                nSRect2.y /= f;
                nSRect2.width /= f;
                nSRect2.height /= f;
                NSBezierPath.bezierPathWithRect(nSRect2).setClip();
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.translateXBy(nSRect2.x, nSRect2.y);
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                nSAffineTransform.scaleXBy((float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
                nSAffineTransform.concat();
                this.operation.context().saveGraphicsState();
                Object var9_9 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_10 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public void endPage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 66->70)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Point getDPI() {
        Point point;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                point = this.getIndependentDPI();
                Object var2_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var2_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return point;
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    public Rectangle getBounds() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize nSSize = this.printInfo.paperSize();
                float f = this.scalingFactor();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(nSSize.width * (float)point.x / (float)point2.x / f), (int)(nSSize.height * (float)point.y / (float)point2.y / f));
                Object var6_7 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_8 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public Rectangle getClientArea() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float f = this.scalingFactor();
                NSRect nSRect = this.printInfo.imageablePageBounds();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(nSRect.width * (float)point.x / (float)point2.x / f), (int)(nSRect.height * (float)point.y / (float)point2.y / f));
                Object var6_7 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_8 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

