/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.Console;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AnalyzerIWSC {
    private static HashSet<ChangePair> cc = new HashSet();
    private static HashSet<ChangePair> ci = new HashSet();
    private static HashSet<ChangePair> ic = new HashSet();
    private static HashSet<ChangePair> ii = new HashSet();
    private static HashMap<Integer, Commit> commits = new HashMap();
    private static final String[] SYSTEMS = new String[]{"bauhaus", "httpd", "jabref"};

    private static void readCommits(String system) {
        Console.debug("Reading commits for system '" + system + "'...");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        String line = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader("/local/users/nils/test/iwsc/" + system + "-2005-2009.log"));
            line = r.readLine();
            while (line != null) {
                if (line.startsWith("r") && line.contains("|")) {
                    String[] tokens = line.split("\\|");
                    int revision = Integer.parseInt(tokens[0].substring(1).trim());
                    String author = tokens[1].trim();
                    Date time = sdf.parse(tokens[2].substring(0, tokens[2].indexOf(40) - 1).trim());
                    commits.put(revision, new Commit(author, time));
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
    }

    public static void analyze(CloneEvolutionGraph ceg) {
        List<Object> l;
        for (String s : SYSTEMS) {
            if (!ceg.getVersions().get(0).getPath().contains(s)) continue;
            AnalyzerIWSC.readCommits(s);
            break;
        }
        Console.debug("Analyzing genealogies...");
        ArrayList<Genealogy> co = new ArrayList<Genealogy>();
        ArrayList<Genealogy> io = new ArrayList<Genealogy>();
        ArrayList<Genealogy> iac = new ArrayList<Genealogy>();
        ArrayList<Genealogy> ibc = new ArrayList<Genealogy>();
        for (Genealogy g : ceg.getGenealogies()) {
            if (g.getChangeFrequency() < 2) continue;
            l = new ArrayList<CloneClass>();
            l.addAll(g.getConsistent());
            l.addAll(g.getInconsistent());
            Collections.sort(l, new Comparator<CloneClass>(){

                @Override
                public int compare(CloneClass a, CloneClass b) {
                    if (a.getRevision().getID() < b.getRevision().getID()) {
                        return -1;
                    }
                    if (a.getRevision().getID() > b.getRevision().getID()) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (g.getConsistent().size() == 0) {
                io.add(g);
                continue;
            }
            if (g.getInconsistent().size() == 0) {
                co.add(g);
                continue;
            }
            CloneClass earliestConsistent = g.getConsistent().iterator().next();
            CloneClass latestInconsistent = g.getInconsistent().iterator().next();
            for (CloneClass c : g.getConsistent()) {
                if (c.getRevision().getID() >= earliestConsistent.getRevision().getID()) continue;
                earliestConsistent = c;
            }
            for (CloneClass c : g.getInconsistent()) {
                if (c.getRevision().getID() <= latestInconsistent.getRevision().getID()) continue;
                latestInconsistent = c;
            }
            if (latestInconsistent.getRevision().getID() > earliestConsistent.getRevision().getID()) {
                iac.add(g);
                continue;
            }
            ibc.add(g);
        }
        Collections.sort(co, new Comparator<Genealogy>(){

            @Override
            public int compare(Genealogy a, Genealogy b) {
                if (a.getConsistent().size() < b.getConsistent().size()) {
                    return -1;
                }
                if (b.getConsistent().size() < a.getConsistent().size()) {
                    return 1;
                }
                return 0;
            }
        });
        Console.debug("Analyzing change pairs...");
        for (Genealogy g : ceg.getGenealogies()) {
            l = AnalyzerIWSC.getChangedCloneClassesAsList(g);
            CloneClass last = null;
            for (CloneClass cloneClass : l) {
                if (last != null) {
                    ChangePair cp = new ChangePair(last, cloneClass);
                    if (cp.type == ChangePairType.CC) {
                        cc.add(cp);
                    }
                    if (cp.type == ChangePairType.CI) {
                        ci.add(cp);
                    }
                    if (cp.type == ChangePairType.IC) {
                        ic.add(cp);
                    }
                    if (cp.type == ChangePairType.II) {
                        ii.add(cp);
                    }
                }
                last = cloneClass;
            }
        }
        int[] highs = new int[]{2031, 2086, 2102, 2196, 2199, 3460, 4263, 4280, 28451};
        int[] lows = new int[]{1500, 1973, 1975, 1977, 2054, 2640, 2933, 3036, 4295, 5334, 5351, 5353, 5398, 5399, 5400, 5411, 5412, 6181, 6757, 7021, 7262, 7373, 7396, 8957, 9409, 13123, 13792, 14898, 16208, 16529, 16539, 20678, 20690, 21671, 26290, 27340};
        Console.message(">>> HIGH");
        AnalyzerIWSC.check(highs);
        Console.message(">>> LOW");
        AnalyzerIWSC.check(lows);
    }

    private static void check(int[] ids) {
        for (int id : ids) {
            AnalyzerIWSC.check(id, ci, "CI");
            AnalyzerIWSC.check(id, ic, "IC");
            AnalyzerIWSC.check(id, ii, "II");
        }
    }

    private static void check(int id, HashSet<ChangePair> cps, String name) {
        for (ChangePair p : cps) {
            if (p.a.getID() == id) {
                Console.message(id + " is part of a " + name + " pair.");
                Console.message(p.toString());
                continue;
            }
            if (p.b.getID() != id) continue;
            Console.message(id + " is part of a " + name + " pair.");
            Console.message(p.toString());
        }
    }

    private static List<CloneClass> getChangedCloneClassesAsList(Genealogy g) {
        ArrayList<CloneClass> changedClasses = new ArrayList<CloneClass>();
        changedClasses.addAll(g.getConsistent());
        changedClasses.addAll(g.getInconsistent());
        Collections.sort(changedClasses, new Comparator<CloneClass>(){

            @Override
            public int compare(CloneClass a, CloneClass b) {
                if (a.getRevision().getID() < b.getRevision().getID()) {
                    return -1;
                }
                if (a.getRevision().getID() > b.getRevision().getID()) {
                    return 1;
                }
                return 0;
            }
        });
        return changedClasses;
    }

    public static double getAverageDistanceBetweenChanges(Genealogy g) {
        List<CloneClass> l = AnalyzerIWSC.getChangedCloneClassesAsList(g);
        double dist = 0.0;
        CloneClass last = null;
        for (CloneClass c : l) {
            if (last != null) {
                dist += (double)(c.getRevision().getID() - last.getRevision().getID());
            }
            last = c;
        }
        return l.size() < 2 ? 0.0 : dist / (double)(l.size() - 1);
    }

    public static List<Number> getChangeIntervals(Genealogy g) {
        ArrayList<Number> intervals = new ArrayList<Number>();
        List<CloneClass> l = AnalyzerIWSC.getChangedCloneClassesAsList(g);
        CloneClass last = null;
        for (CloneClass c : l) {
            if (last != null) {
                intervals.add(AnalyzerIWSC.getTimeBetween(last.getRevision(), c.getRevision()));
            }
            last = c;
        }
        return intervals;
    }

    public static List<Number> getICIntervals(Genealogy g) {
        ArrayList<Number> intervals = new ArrayList<Number>();
        List<CloneClass> l = AnalyzerIWSC.getChangedCloneClassesAsList(g);
        CloneClass last = null;
        for (CloneClass c : l) {
            if (last != null && c.isInconsistentlyChanged()) {
                intervals.add(AnalyzerIWSC.getTimeBetween(last.getRevision(), c.getRevision()));
                last = null;
            }
            if (!c.isConsistentlyChanged()) continue;
            last = c;
        }
        return intervals;
    }

    public static double getConsistencyDistance(Genealogy g) {
        List<CloneClass> l = AnalyzerIWSC.getChangedCloneClassesAsList(g);
        double dist = 0.0;
        CloneClass last = null;
        for (CloneClass c : l) {
            if (last != null && c.isInconsistentlyChanged()) {
                dist += (double)(c.getRevision().getID() - last.getRevision().getID());
                last = null;
            }
            if (!c.isConsistentlyChanged()) continue;
            last = c;
        }
        return l.size() < 2 ? 0.0 : dist / (double)(l.size() - 1);
    }

    private static double getTimeBetween(Version earlierRevision, Version laterRevision) {
        int r = AnalyzerIWSC.getRevision(earlierRevision);
        if (!commits.containsKey(r)) {
            System.out.println("No LOG entry for revision " + r);
        }
        Date early = AnalyzerIWSC.commits.get((Object)Integer.valueOf((int)r)).time;
        if (!commits.containsKey(r)) {
            System.out.println("No LOG entry for revision " + r);
        }
        r = AnalyzerIWSC.getRevision(laterRevision);
        Date late = AnalyzerIWSC.commits.get((Object)Integer.valueOf((int)r)).time;
        Calendar c = Calendar.getInstance();
        long start = early.getTime() + (long)c.getTimeZone().getOffset(early.getTime());
        long end = late.getTime() + (long)c.getTimeZone().getOffset(late.getTime());
        double result = (double)(end - start) / 8.64E7;
        return result;
    }

    private static int getRevision(Version v) {
        return Integer.parseInt(v.getPath().substring(v.getPath().lastIndexOf(47) + 1));
    }

    private static class Commit {
        public String author;
        public Date time;

        public Commit(String author, Date time) {
            this.author = author;
            this.time = time;
        }
    }

    private static class ChangePair {
        public CloneClass a;
        public CloneClass b;
        public ChangePairType type;
        public double delay;
        public boolean solo;
        public boolean sameFile;

        public ChangePair(CloneClass a, CloneClass b) {
            this.a = a;
            this.b = b;
            this.type = a.isConsistentlyChanged() ? (b.isConsistentlyChanged() ? ChangePairType.CC : ChangePairType.CI) : (b.isConsistentlyChanged() ? ChangePairType.IC : ChangePairType.II);
            this.delay = AnalyzerIWSC.getTimeBetween(a.getRevision(), b.getRevision());
            this.solo = ((Commit)commits.get((Object)Integer.valueOf((int)AnalyzerIWSC.getRevision((Version)a.getRevision())))).author.equals(((Commit)commits.get((Object)Integer.valueOf((int)AnalyzerIWSC.getRevision((Version)b.getRevision())))).author);
            String file = a.getFragments().get(0).getFile().substring(a.getRevision().getPath().length());
            this.sameFile = true;
            for (Fragment f : a.getFragments()) {
                if (file.equals(f.getFile().substring(a.getRevision().getPath().length()))) continue;
                this.sameFile = false;
                break;
            }
        }

        public String toString() {
            return this.type.toString() + ": " + this.a.getID() + " - " + this.b.getID() + " (Delay = " + this.delay + ", Solo = " + this.solo + ", Same file = " + this.sameFile + ")";
        }
    }

    static enum ChangePairType {
        CC,
        CI,
        IC,
        II;

    }
}

