/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone;

import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.CycloneFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;

public class Cyclone {
    private static final String CONFIG_FILE = System.getProperty("user.home") + File.separator + ".cyclone";
    private static final boolean RELEASE = true;
    private static final String VERSION = "0.1.3";
    private static Properties config;

    public static Properties getConfig() {
        if (config == null) {
            config = new Properties();
            try {
                FileInputStream fis = new FileInputStream(CONFIG_FILE);
                config.load(fis);
                fis.close();
            }
            catch (IOException ioe) {
                String message = "I can't find a configuration at '" + CONFIG_FILE + "'. I create a new one.";
                if (Console.isInitialized()) {
                    Console.message(message);
                }
                System.out.println(message);
            }
        }
        return config;
    }

    public static void saveConfig() {
        try {
            FileOutputStream fos = new FileOutputStream(CONFIG_FILE);
            Cyclone.getConfig().store(fos, null);
            fos.close();
        }
        catch (IOException ioe) {
            String message = "I can't write configuration to '" + CONFIG_FILE + "'";
            if (Console.isInitialized()) {
                Console.error(message);
            } else {
                System.err.println(message);
            }
            ioe.printStackTrace();
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isRelease() {
        return true;
    }

    public static String makeNativePath(String p) {
        String result = p.replace('/', File.separatorChar);
        return result.replace('\\', File.separatorChar);
    }

    public static void main(String[] args) {
        int j;
        int i;
        if (args.length > 0) {
            System.out.println("WARNING: I don't accept any arguments, I ignore them!");
        }
        String SWT_JAR = "swt.jar";
        String classpath = System.getProperty("java.class.path");
        File dest = new File(classpath.substring((i = classpath.lastIndexOf(File.pathSeparatorChar, j = classpath.indexOf("swt.jar"))) + 1, j + 7));
        if (!dest.exists()) {
            System.out.println("> The file '" + dest.getAbsolutePath() + "' does not exist.");
            System.out.println("> This is probably the first time you start cyclone.");
            String architecture = System.getProperty("os.arch");
            String os = System.getProperty("os.name");
            int bit = architecture.contains("64") ? 64 : 32;
            String jarName = "";
            try {
                File cycloneJar = new File(Cyclone.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                jarName = cycloneJar.getParent() + "/";
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            jarName = jarName + "swt/swt";
            if (os.equals("Linux")) {
                jarName = jarName + "-linux";
                System.out.println("> You appear to be using Linux.");
            } else if (os.toLowerCase().contains("win")) {
                jarName = jarName + "-windows";
                System.out.println("> You appear to be using Windows.");
            } else {
                jarName = jarName + "-mac";
                System.out.println("> You appear to be using a Mac.");
            }
            jarName = jarName + "-" + bit + ".jar";
            System.out.println("> You seem to be running a " + bit + "-Bit Java virtual machine.");
            File source = new File(jarName);
            System.out.println("> I'll try to copy '" + source.getAbsolutePath() + "' to '" + dest.getAbsolutePath() + ".");
            try {
                FileInputStream fis = new FileInputStream(source);
                FileOutputStream fos = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = fis.read(buf)) != -1) {
                    fos.write(buf, 0, n);
                }
                fis.close();
                fos.close();
            }
            catch (Exception e) {
                System.out.println("> For some reason I cannot copy the file. You may try to manually copy the correct JAR from '" + source.getParent() + File.separatorChar + "' to '" + dest.getParent() + File.separatorChar + "'. Ensure that it is named 'swt.jar'.");
            }
            System.out.println("> Copying was successful. If, however, my guesses were wrong, you may manually copy the correct JAR from '" + source.getParent() + File.separatorChar + "' to '" + dest.getParent() + File.separatorChar + "'. Ensure that it is named 'swt.jar'.");
        }
        new CycloneFrame();
    }
}

