/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.io.RCFManager;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.schema.AttributeType;

public abstract class AbstractModelEntity {
    protected int id;
    private boolean visible = true;
    private boolean marked = false;
    protected String rcfrelation = null;
    public Entry rcftuple;

    public AbstractModelEntity(String rcfrelation) {
        this.rcfrelation = rcfrelation;
    }

    public int getID() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public void mark() {
        this.setMarked(true);
    }

    public void unmark() {
        this.setMarked(false);
    }

    protected String getRCFAttributeValue(String attr, String defaultValue) {
        Entry t;
        Relation<Entry> r = this.getRCFRelation();
        if (r != null && r.hasAttribute(attr) && (t = this.getRCFTuple()).isSet(attr)) {
            return t.getString(attr);
        }
        return defaultValue;
    }

    protected RCF getRCF() {
        return RCFManager.getCurrentRCF();
    }

    protected Relation<Entry> getRCFRelation() {
        if (this.getRCF() != null) {
            return this.getRCF().getRelation(this.rcfrelation);
        }
        return null;
    }

    protected Attribute getRCFAttribute(String name) {
        Relation<Entry> r = this.getRCFRelation();
        if (r != null) {
            Attribute a = null;
            a = r.hasAttribute(name) ? r.getAttribute(name) : r.addAttribute(name, AttributeType.STRING, null, false, false, null);
            return a;
        }
        return null;
    }

    protected Entry getRCFTuple() {
        RCF rcf = this.getRCF();
        if (this.rcftuple != null) {
            return this.rcftuple;
        }
        if (rcf != null) {
            Relation<Entry> r = rcf.getRelation(this.rcfrelation);
            return r.getEntry(this.getID());
        }
        return null;
    }
}

