/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public class CloneClass
extends AbstractModelEntity
implements Comparable<CloneClass> {
    private List<Fragment> fragments;
    private boolean incChanged;
    private boolean conChanged;
    private Version revision;
    private Genealogy genealogy = null;
    private int type;
    private Rectangle bounds;

    public CloneClass(int id, Version revision, boolean incChanged, boolean conChanged) {
        super("CloneClass");
        this.id = id;
        this.revision = revision;
        this.incChanged = incChanged;
        this.conChanged = conChanged;
        this.fragments = new ArrayList<Fragment>();
    }

    public CloneClass(int id, Version revision, int type) {
        super("CloneClass");
        this.id = id;
        this.revision = revision;
        this.type = type;
        this.fragments = new ArrayList<Fragment>();
        this.incChanged = false;
        this.conChanged = false;
    }

    public void addFragment(Fragment f) {
        this.fragments.add(f);
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public Genealogy getGenealogy() {
        return this.genealogy;
    }

    public void setGenealogy(Genealogy g) {
        this.genealogy = g;
        this.revision.addGenealogy(g);
    }

    public List<Fragment> getVisibleFragments() {
        ArrayList<Fragment> l = new ArrayList<Fragment>();
        for (Fragment f : this.fragments) {
            if (!f.isVisible()) continue;
            l.add(f);
        }
        return l;
    }

    public void setInconsistentlyChanged() {
        this.incChanged = true;
    }

    public void setConsistentlyChanged() {
        this.conChanged = true;
    }

    public boolean isChanged() {
        return this.incChanged || this.conChanged;
    }

    public boolean isInconsistentlyChanged() {
        return this.incChanged;
    }

    public boolean isConsistentlyChanged() {
        return this.conChanged;
    }

    public Version getRevision() {
        return this.revision;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String result = "Class " + this.id + " (Type " + this.type + ")";
        return result;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void sort() {
        Collections.sort(this.fragments);
    }

    @Override
    public int compareTo(CloneClass other) {
        int result = other.getFragments().get(0).compareTo(this.fragments.get(0));
        for (int i = 1; result == 0 && i < other.getFragments().size() && i < this.fragments.size(); ++i) {
            result = other.getFragments().get(i).compareTo(this.fragments.get(i));
        }
        if (result == 0) {
            if (other.getFragments().size() < this.fragments.size()) {
                return -1;
            }
            if (other.getFragments().size() > this.fragments.size()) {
                return 1;
            }
        }
        return result;
    }
}

