/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.ArrayList;
import java.util.List;

public class CloneEvolutionGraph {
    private List<Version> versions;
    private List<Genealogy> genealogies;
    private List<Fragment> fragments;

    public CloneEvolutionGraph(List<Version> versions) {
        assert (versions != null);
        this.versions = versions;
        this.genealogies = new ArrayList<Genealogy>();
        this.fragments = new ArrayList<Fragment>();
        for (Version v : versions) {
            for (CloneClass c : v.getCloneClasses().values()) {
                if (c.getGenealogy() != null) continue;
                Genealogy g = new Genealogy();
                CloneEvolutionGraph.collectGenealogy(c, g, -1);
                this.genealogies.add(g);
            }
        }
        for (Version v : versions) {
            for (CloneClass c : v.getCloneClasses().values()) {
                for (Fragment f : c.getFragments()) {
                    if (!f.getAncestors().isEmpty()) continue;
                    this.fragments.add(f);
                }
            }
        }
    }

    public List<Genealogy> getGenealogies() {
        return this.genealogies;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public double getMeanFragmentLifetime() {
        double result = 0.0;
        double fragments = 0.0;
        for (Version v : this.versions) {
            for (CloneClass c : v.getCloneClasses().values()) {
                for (Fragment f : c.getFragments()) {
                    if (!f.getAncestors().isEmpty()) continue;
                    result += (double)f.getLifetime();
                    fragments += 1.0;
                }
            }
        }
        return fragments == 0.0 ? 0.0 : result / fragments;
    }

    public int getMedianFragmentLifetime() {
        int fragments = 0;
        int[] lifetimes = new int[this.versions.size()];
        for (Version v : this.versions) {
            for (CloneClass c : v.getCloneClasses().values()) {
                for (Fragment f : c.getFragments()) {
                    if (!f.getAncestors().isEmpty()) continue;
                    int n = f.getLifetime() - 1;
                    lifetimes[n] = lifetimes[n] + 1;
                    ++fragments;
                }
            }
        }
        int i = 0;
        int goal = fragments / 2;
        for (int sum = 0; sum < goal; sum += lifetimes[i++]) {
        }
        return i;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    private static void collectGenealogy(CloneClass cc, Genealogy g, int last) {
        if (cc.getGenealogy() != null) {
            return;
        }
        g.add(cc);
        cc.setGenealogy(g);
        for (Fragment f : cc.getFragments()) {
            for (Fragment p : f.getAncestors()) {
                if (p.getCloneClass().getID() == last) continue;
                CloneEvolutionGraph.collectGenealogy(p.getCloneClass(), g, cc.getID());
            }
            if (f.getDescendant() == null || f.getDescendant().getCloneClass().getID() == last) continue;
            CloneEvolutionGraph.collectGenealogy(f.getDescendant().getCloneClass(), g, cc.getID());
        }
    }
}

