/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CloneStatistics {
    public static List<CloneClass> getAllClasses(List<Version> revisions) {
        ArrayList<CloneClass> result = new ArrayList<CloneClass>();
        for (Version r : revisions) {
            ArrayList<CloneClass> temp = new ArrayList<CloneClass>(r.getVisibleCloneClasses().values());
            Collections.sort(temp);
            result.addAll(temp);
        }
        return result;
    }

    public static Set<CloneClass> getConIncClasses(List<Version> revisions) {
        HashSet<CloneClass> result = new HashSet<CloneClass>();
        for (Version r : revisions) {
            for (Fragment f : r.getVisibleFragments().values()) {
                if (!f.getAncestors().isEmpty()) continue;
                CloneClass cons = null;
                for (Fragment d = f; d != null; d = d.getDescendant()) {
                    if (d.getCloneClass().isConsistentlyChanged()) {
                        cons = d.getCloneClass();
                        continue;
                    }
                    if (!d.getCloneClass().isInconsistentlyChanged() || cons == null) continue;
                    result.add(cons);
                }
            }
        }
        return result;
    }

    public static Set<CloneClass> getTypeChangedClasses(List<Version> revisions) {
        HashSet<CloneClass> result = new HashSet<CloneClass>();
        for (Version r : revisions) {
            block1: for (Fragment f : r.getVisibleFragments().values()) {
                for (Fragment a : f.getAncestors()) {
                    if (f.getCloneClass().getType() == a.getCloneClass().getType()) continue;
                    result.add(f.getCloneClass());
                    continue block1;
                }
            }
        }
        return result;
    }
}

