/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.Controller;

public class Filter
implements CloneEvolutionGraphListener {
    private CloneEvolutionGraph ceg;

    public void reset() {
        for (Genealogy g : this.ceg.getGenealogies()) {
            g.setVisible(true);
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    public void removeStaticGenealogies() {
        for (Genealogy g : this.ceg.getGenealogies()) {
            if (!g.isStatic()) continue;
            g.setVisible(false);
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    public void removeExcessiveGenealogies() {
        for (Genealogy g : this.ceg.getGenealogies()) {
            if (!g.isExcessive()) continue;
            g.setVisible(false);
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    public void removeSingleModuleGenealogies() {
        for (Genealogy g : this.ceg.getGenealogies()) {
            if (!g.isSingleModule()) continue;
            g.setVisible(false);
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    public void invert() {
        for (Genealogy g : this.ceg.getGenealogies()) {
            g.setVisible(!g.isVisible());
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    public void removeGenealogiesByPath(String path, boolean invert) {
        for (Genealogy g : this.ceg.getGenealogies()) {
            g.setVisible(g.isRelatedTo(path) != invert);
        }
        Controller.revisionsChanged(this.ceg, this);
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.ceg = g;
    }
}

