/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public class Fragment
extends AbstractModelEntity
implements Comparable<Fragment> {
    private SourceFile sourceFile;
    private int start = -1;
    private int end = -1;
    private int startLine;
    private int endLine;
    private List<Fragment> ancestors;
    private Fragment descendant;
    private CloneClass cloneClass;
    private int length;
    private int alphabetSize = -1;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);

    public Fragment(int id, int startLine, int endLine, int start, int end, int length, SourceFile sourceFile, List<Fragment> ancestors, CloneClass c) {
        super("Fragment");
        this.id = id;
        this.startLine = startLine;
        this.endLine = endLine;
        this.start = start;
        this.end = end;
        this.length = length;
        this.sourceFile = sourceFile;
        this.cloneClass = c;
        this.ancestors = ancestors;
        for (Fragment a : ancestors) {
            a.setDescendant(this);
        }
    }

    public CloneClass getCloneClass() {
        return this.cloneClass;
    }

    public List<Fragment> getAncestors() {
        return this.ancestors;
    }

    public String getFile() {
        return this.sourceFile == null ? null : this.sourceFile.getPath();
    }

    public String getRelativeFilePath() {
        return this.sourceFile == null ? null : this.sourceFile.getPath().substring(this.getVersion().getPath().length() + 2);
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getLength() {
        return this.length;
    }

    public int getLifetime() {
        return this.descendant == null ? 1 : 1 + this.descendant.getLifetime();
    }

    public Version getVersion() {
        return this.sourceFile.getVersion();
    }

    public void setAlphabetSize(int alphabetSize) {
        this.alphabetSize = alphabetSize;
    }

    public void setDescendant(Fragment f) {
        this.descendant = f;
    }

    public Fragment getDescendant() {
        return this.descendant;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public int compareTo(Fragment other) {
        if (!this.sourceFile.equals(other.getSourceFile())) {
            return this.sourceFile.compareTo(other.getSourceFile());
        }
        if (this.startLine != other.getStartLine()) {
            return this.startLine < other.getStartLine() ? -1 : 1;
        }
        if (this.endLine == other.getEndLine()) {
            return 0;
        }
        return this.endLine < other.getEndLine() ? -1 : 1;
    }

    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public int getAlphabetSize() {
        return this.alphabetSize;
    }

    public boolean isWithin(int offset, int line) {
        if (this.end >= 0) {
            return offset >= this.start && offset <= this.end;
        }
        return line >= this.startLine && line <= this.endLine;
    }
}

