/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.HashSet;
import java.util.Set;

public class Genealogy {
    private Set<CloneClass> cloneClasses = new HashSet<CloneClass>();
    private Set<CloneClass> consistent = new HashSet<CloneClass>();
    private Set<CloneClass> inconsistent = new HashSet<CloneClass>();
    private Version first = null;
    private Version last = null;
    private boolean visible = true;

    public void add(CloneClass cc) {
        assert (cc != null);
        this.cloneClasses.add(cc);
        if (cc.isConsistentlyChanged()) {
            this.consistent.add(cc);
        } else if (cc.isInconsistentlyChanged()) {
            this.inconsistent.add(cc);
        }
        if (this.first == null || cc.getRevision().getID() < this.first.getID()) {
            this.first = cc.getRevision();
        }
        if (this.last == null || cc.getRevision().getID() > this.last.getID()) {
            this.last = cc.getRevision();
        }
    }

    public int getChangeFrequency() {
        return this.consistent.size() + this.inconsistent.size();
    }

    public Set<CloneClass> getCloneClasses() {
        return this.cloneClasses;
    }

    public Set<CloneClass> getCloneClasses(int versionID) {
        HashSet<CloneClass> classes = new HashSet<CloneClass>();
        for (CloneClass cc : this.cloneClasses) {
            if (cc.getRevision().getID() != versionID) continue;
            classes.add(cc);
        }
        return classes;
    }

    public Set<CloneClass> getConsistent() {
        return this.consistent;
    }

    public Set<CloneClass> getFirstCloneClasses() {
        return this.getCloneClasses(this.first.getID());
    }

    public Version getFirstVersion() {
        return this.first;
    }

    public Set<CloneClass> getInconsistent() {
        return this.inconsistent;
    }

    public Set<CloneClass> getLastCloneClasses() {
        return this.getCloneClasses(this.last.getID());
    }

    public Version getLastVersion() {
        return this.last;
    }

    public int getLifetime() {
        if (this.first == null || this.last == null) {
            return 0;
        }
        int lifetime = 1;
        Version v = this.first;
        while (v.getID() != this.last.getID()) {
            ++lifetime;
            v = v.next();
        }
        return lifetime;
    }

    public boolean isExcessive() {
        if (this.first == null || this.last == null) {
            return false;
        }
        return this.first.previous() == null || this.last.next() == null;
    }

    public boolean isRelatedTo(String expression) {
        for (CloneClass c : this.cloneClasses) {
            for (Fragment f : c.getFragments()) {
                if (!f.getFile().contains(expression)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleModule() {
        if (this.cloneClasses.isEmpty()) {
            return true;
        }
        String module = this.cloneClasses.iterator().next().getFragments().get(0).getFile();
        int i = (module = module.substring(this.cloneClasses.iterator().next().getRevision().getPath().length() + 1)).indexOf(47);
        if (i >= 0) {
            module = module.substring(0, i);
        }
        for (CloneClass cc : this.cloneClasses) {
            for (Fragment f : cc.getFragments()) {
                String s = f.getFile().substring(f.getVersion().getPath().length() + 1);
                i = s.indexOf(47);
                if (i >= 0) {
                    s = s.substring(0, i);
                }
                if (module.equals(s)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStatic() {
        if (this.first == null || this.last == null) {
            return false;
        }
        if (this.consistent.size() > 0 || this.inconsistent.size() > 0) {
            return false;
        }
        int n = this.cloneClasses.iterator().next().getFragments().size();
        for (CloneClass c : this.cloneClasses) {
            if (c.getFragments().size() == n) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
        for (CloneClass c : this.cloneClasses) {
            c.setVisible(v);
        }
    }
}

