/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.clones;

import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.Console;
import edu.tum.cs.scanner.ELanguage;
import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.ILenientScanner;
import edu.tum.cs.scanner.IToken;
import edu.tum.cs.scanner.ScannerException;
import edu.tum.cs.scanner.ScannerFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SourceContext {
    private SourceFile file;
    private Fragment fragment;
    private String text;
    private List<IToken> fileTokens = new ArrayList<IToken>();
    private List<IToken> fragmentTokens = new ArrayList<IToken>();
    private List<String> fileLines = new ArrayList<String>();
    private List<String> fragmentLines = new ArrayList<String>();
    private boolean valid = false;

    public SourceContext(Fragment f) {
        this(f.getSourceFile(), f);
    }

    public SourceContext(SourceFile sf) {
        this(sf, null);
    }

    private SourceContext(SourceFile sf, Fragment f) {
        assert (sf != null);
        this.file = sf;
        this.fragment = f;
        try {
            StringBuffer sb = new StringBuffer();
            File sourceFile = new File(this.file.getNativePath());
            if (!sourceFile.exists()) {
                sourceFile = this.findSourceFile(this.file);
            }
            if (sourceFile == null) {
                return;
            }
            LineNumberReader lnr = new LineNumberReader(new FileReader(sourceFile));
            String line = lnr.readLine();
            while (line != null) {
                sb.append(line + '\n');
                String transformedLine = line.trim().replaceAll(" ", "");
                this.fileLines.add(transformedLine);
                if (this.fragment != null && lnr.getLineNumber() >= this.fragment.getStartLine() && lnr.getLineNumber() <= this.fragment.getEndLine()) {
                    this.fragmentLines.add(transformedLine);
                }
                line = lnr.readLine();
            }
            lnr.close();
            this.text = sb.toString();
            ILenientScanner scanner = ScannerFactory.newLenientScanner(ELanguage.fromFileExtension(sourceFile), sourceFile);
            IToken t = null;
            try {
                t = scanner.getNextToken();
                while (t != null && t.getType() != ETokenType.EOF) {
                    this.fileTokens.add(t);
                    if (this.fragment != null && this.fragment.isWithin(t.getOffset(), t.getLineNumber() + 1)) {
                        this.fragmentTokens.add(t);
                    }
                    t = scanner.getNextToken();
                }
            }
            catch (ScannerException e) {
                Console.error("I can't scan the file, because of " + e.getMessage());
                e.printStackTrace();
            }
            scanner.close();
        }
        catch (IOException e) {
            Console.error("I can't load source code from " + this.file.getNativePath() + ", because of: " + e.getMessage());
            e.printStackTrace();
        }
        this.valid = true;
    }

    public List<String> getFileLines() {
        assert (this.valid);
        return this.fileLines;
    }

    public List<IToken> getFileTokens() {
        assert (this.valid);
        return this.fileTokens;
    }

    public Fragment getFragment() {
        assert (this.valid);
        return this.fragment;
    }

    public List<String> getFragmentLines() {
        assert (this.valid);
        return this.fragmentLines;
    }

    public List<IToken> getFragmentTokens() {
        assert (this.valid);
        return this.fragmentTokens;
    }

    public int getLOC() {
        assert (this.valid);
        return this.file.getLOC();
    }

    public SourceFile getSourceFile() {
        assert (this.valid);
        return this.file;
    }

    public String getText() {
        assert (this.valid);
        return this.text;
    }

    public boolean hasFragment() {
        assert (this.valid);
        return this.fragment != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    private File findSourceFile(SourceFile sf) {
        File result = null;
        Version v = sf.getVersion();
        String path = v.getPath();
        File dir = new File(path = path.substring(0, path.lastIndexOf(47)));
        if (dir.isDirectory()) {
            Object[] dirs = dir.listFiles();
            Arrays.sort(dirs);
            for (Object d : dirs) {
                if (((File)d).getAbsolutePath().equals(v.getPath())) {
                    if (result == null) {
                        Console.error("I cannot find the last occurence of file '" + sf.getPath() + "' in the file system. Clone " + "information and source code are inconsistent!");
                    }
                    return result;
                }
                File file = new File((File)d, sf.getNativePath().substring(v.getPath().length()));
                if (!file.exists()) continue;
                result = file;
            }
        }
        Console.error("I cannot find the directory for version '" + v.getPath() + "'. Clone information and source code are " + "inconsistent!");
        return result;
    }

    public int getFragmentParameterCount() {
        int count = 0;
        for (IToken t : this.getFragmentTokens()) {
            if (!t.getType().isLiteral() && !t.getType().isIdentifier()) continue;
            ++count;
        }
        return count;
    }

    public int getFragmentParameterVocabulary() {
        HashSet<String> parameters = new HashSet<String>();
        for (IToken t : this.getFragmentTokens()) {
            if (!t.getType().isLiteral() && !t.getType().isIdentifier()) continue;
            parameters.add(t.getText());
        }
        return parameters.size();
    }

    public int getFragmentVocabulary() {
        HashSet<ETokenType> parameters = new HashSet<ETokenType>();
        for (IToken t : this.getFragmentTokens()) {
            parameters.add(t.getType());
        }
        return parameters.size();
    }
}

