/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.control;

import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.control.ChangeListener;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.FragmentSelectionListener;
import de.uni_bremen.st.cyclone.control.SourcesLocationListener;
import java.util.ArrayList;
import java.util.List;

public class Controller {
    private static List<ChangeListener> cListeners = new ArrayList<ChangeListener>();
    private static List<ClassSelectionListener> cscListeners = new ArrayList<ClassSelectionListener>();
    private static List<CloneEvolutionGraphListener> rcListeners = new ArrayList<CloneEvolutionGraphListener>();
    private static List<FragmentSelectionListener> fsListeners = new ArrayList<FragmentSelectionListener>();
    private static List<SourcesLocationListener> slListeners = new ArrayList<SourcesLocationListener>();

    public static void addChangeListener(ChangeListener l) {
        cListeners.add(l);
    }

    public static void addClassSelectionListener(ClassSelectionListener cscl) {
        cscListeners.add(cscl);
    }

    public static void addFragmentSelectionListener(FragmentSelectionListener fsl) {
        fsListeners.add(fsl);
    }

    public static void addRevisionsListener(CloneEvolutionGraphListener rcl) {
        rcListeners.add(rcl);
    }

    public static void addSourcesLocationListener(SourcesLocationListener sll) {
        slListeners.add(sll);
    }

    public static void classSelectionChanged(CloneClass cc, Object source) {
        for (ClassSelectionListener cscl : cscListeners) {
            if (cscl.equals(source)) continue;
            cscl.classSelectionChanged(cc);
        }
    }

    public static void fragmentSelectionChanged(Fragment f) {
        for (FragmentSelectionListener fsl : fsListeners) {
            fsl.fragmentSelectionChanged(f);
        }
    }

    public static void revisionsChanged(CloneEvolutionGraph g, Object source) {
        for (CloneEvolutionGraphListener rcl : rcListeners) {
            if (rcl.equals(source)) continue;
            rcl.cloneEvolutionGraphChanged(g);
        }
    }

    public static void sourcesLocationChanged(String sl) {
        for (SourcesLocationListener sll : slListeners) {
            sll.sourcesLocationChanged(sl);
        }
    }

    public static void elementChanged(AbstractModelEntity e, ChangeListener ignore) {
        for (ChangeListener l : cListeners) {
            if (l == ignore) continue;
            l.elementChanged(e);
        }
    }
}

