/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.io;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.control.ProgressListener;
import de.uni_bremen.st.cyclone.system.Directory;
import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.util.Worker;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Metadata;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.PersistenceManagerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RCFManager
implements Worker {
    private LinkedList<ProgressListener> pListeners = new LinkedList();
    private File file = null;
    private CloneEvolutionGraph ceg = null;
    private boolean cancelled = false;
    private double entitiesToRead = 0.0;
    private double entitiesRead = 0.0;
    private static RCF currentRCF = null;
    private Map<Integer, SourceFile> files = new HashMap<Integer, SourceFile>();
    private List<Version> versions;

    public static RCF getCurrentRCF() {
        return currentRCF;
    }

    @Override
    public void addProgressListener(ProgressListener pl) {
        this.pListeners.add(pl);
    }

    @Override
    public void run() {
        long timeStart = System.currentTimeMillis();
        this.versions = new ArrayList<Version>();
        AbstractPersistenceManager pm = null;
        try {
            pm = PersistenceManagerFactory.getPersistenceManager(this.file);
        }
        catch (FileNotFoundException e) {
            Console.error("I cannot find file " + this.file.getAbsolutePath());
        }
        assert (pm != null);
        assert (this.file != null);
        RCF rcf = pm.load(this.file);
        double time = (double)(System.currentTimeMillis() - timeStart) / 1000.0;
        long kilobytes = this.file.length() / 1024L;
        double speed = (double)kilobytes / time;
        Console.message("Loaded " + (int)kilobytes + "kB in " + Console.round(time, 1) + "s (" + Console.round(speed, 2) + "kB/s)");
        timeStart = System.currentTimeMillis();
        if (!this.check(rcf)) {
            Console.error("RCF does not contain sufficient data for cyclone.");
            this.fireEnd();
            return;
        }
        currentRCF = rcf;
        int numVersions = rcf.getVersions().size();
        for (Metadata md : rcf.getMetadatas()) {
            if (!md.getKey().equals("execution-start")) continue;
            Console.message("RCF created on " + md.getValue());
        }
        Console.message("Versions:      " + Console.ralign(numVersions, 8));
        int rID = 0;
        Version lastVersion = null;
        for (de.uni_bremen.st.rcf.model.Version v : rcf.getVersions()) {
            this.entitiesToRead += (double)v.getCloneClasses().size();
            this.entitiesToRead += (double)v.getClonePairs().size();
            this.entitiesToRead += (double)v.getFiles().size();
        }
        for (de.uni_bremen.st.rcf.model.Version v : rcf.getVersions()) {
            CloneClass newC;
            int id;
            int type;
            Version r;
            if (this.cancelled) break;
            lastVersion = r = new Version(rID++, v.getCanonicalBasepath() + "/changes", lastVersion);
            r.rcftuple = v;
            for (ProgressListener progressListener : this.pListeners) {
                progressListener.setTaskDescription("Loading files...");
            }
            this.extractFiles(v, r);
            for (ProgressListener progressListener : this.pListeners) {
                progressListener.setTaskDescription("Loading clones...");
            }
            for (de.uni_bremen.st.rcf.model.CloneClass cloneClass : v.getCloneClasses()) {
                if (this.cancelled) break;
                type = cloneClass.isSet("type") ? cloneClass.getType() : 0;
                id = cloneClass.isClientIdSet() ? cloneClass.getClientId() : cloneClass.getId();
                newC = new CloneClass(id, r, type);
                newC.rcftuple = cloneClass;
                for (de.uni_bremen.st.rcf.model.Fragment f : cloneClass.getFragments()) {
                    if (this.cancelled) break;
                    newC.addFragment(this.createFragment(f, newC, v, r));
                }
                Collections.sort(newC.getFragments());
                if (cloneClass.getRelation().hasAttribute("Consistent") && cloneClass.isSet("Consistent") && cloneClass.getBool("Consistent")) {
                    newC.setConsistentlyChanged();
                } else if (cloneClass.getRelation().hasAttribute("Inconsistent") && cloneClass.isSet("Inconsistent") && cloneClass.getBool("Inconsistent")) {
                    newC.setInconsistentlyChanged();
                }
                r.addCloneClass(newC);
                this.entitiesRead += 1.0;
                if (this.entitiesRead % (double)((int)this.entitiesToRead / 100) != 0.0) continue;
                this.fireProgressMade(this.entitiesRead / this.entitiesToRead);
            }
            for (ClonePair clonePair : v.getClonePairs()) {
                if (this.cancelled) break;
                type = clonePair.isSet("type") ? clonePair.getType() : 0;
                id = clonePair.isClientIdSet() ? clonePair.getClientId() : clonePair.getId();
                newC = new CloneClass(id, r, type);
                newC.rcftuple = clonePair;
                newC.addFragment(this.createFragment(clonePair.getLeft(), newC, v, r));
                newC.addFragment(this.createFragment(clonePair.getRight(), newC, v, r));
                Collections.sort(newC.getFragments());
                if (clonePair.getRelation().hasAttribute("Consistent") && clonePair.isSet("Consistent") && clonePair.getBool("Consistent")) {
                    newC.setConsistentlyChanged();
                } else if (clonePair.getRelation().hasAttribute("Inconsistent") && clonePair.isSet("Inconsistent") && clonePair.getBool("Inconsistent")) {
                    newC.setInconsistentlyChanged();
                }
                r.addCloneClass(newC);
                this.entitiesRead += 1.0;
                if (this.entitiesRead % (double)((int)this.entitiesToRead / 100) != 0.0) continue;
                this.fireProgressMade(this.entitiesRead / this.entitiesToRead);
            }
            r.getSource().calculate();
            this.versions.add(r);
        }
        this.ceg = new CloneEvolutionGraph(this.versions);
        Console.message("Genealogies:   " + Console.ralign(this.ceg.getGenealogies().size(), 8));
        time = (System.currentTimeMillis() - timeStart) / 1000L;
        Console.message("CEG created in " + Console.round(time, 1) + "s");
        block10: for (Genealogy g : this.ceg.getGenealogies()) {
            int type = g.getCloneClasses().iterator().next().getType();
            for (CloneClass cloneClass : g.getCloneClasses()) {
                if (cloneClass.getType() == type) continue;
                Console.debug("Type changed from " + type + " to " + cloneClass.getType() + " at class " + cloneClass.getID());
                type = cloneClass.getType();
                continue block10;
            }
        }
        this.fireEnd();
    }

    private void extractFiles(de.uni_bremen.st.rcf.model.Version v, Version r) {
        Directory root = new Directory(null, v.getCanonicalBasepath(), r);
        for (de.uni_bremen.st.rcf.model.File f : v.getFiles()) {
            Directory d = root;
            String s = f.getRelativePath();
            while (s.contains("/")) {
                int i = s.indexOf("/");
                String name = s.substring(0, i);
                for (Entity e : d.getEntities()) {
                    if (!e.getPath().endsWith("/" + name)) continue;
                    d = (Directory)e;
                    name = "";
                    break;
                }
                if (!name.equals("")) {
                    Directory dir = new Directory(d, d.getPath() + "/" + name, r);
                    d.addEntity(dir);
                    d = dir;
                }
                s = s.substring(i + 1);
            }
            SourceFile sf = null;
            sf = f.isLocSet() ? new SourceFile(d, f.getAbsolutePath(), r, f.getLoc()) : new SourceFile(d, f.getAbsolutePath(), r, 0);
            d.addEntity(sf);
            assert (!this.files.containsKey(f.getId()));
            this.files.put(f.getId(), sf);
            this.entitiesRead += 1.0;
            if (this.entitiesRead % (double)((int)this.entitiesToRead / 100) != 0.0) continue;
            this.fireProgressMade(this.entitiesRead / this.entitiesToRead);
        }
        r.setSource(root);
    }

    private Fragment createFragment(de.uni_bremen.st.rcf.model.Fragment f, CloneClass newC, de.uni_bremen.st.rcf.model.Version v, Version revision) {
        int id;
        ArrayList<Fragment> ancestors = new ArrayList<Fragment>();
        int n = id = f.isClientIdSet() ? f.getClientId() : f.getId();
        if (id > 0) {
            for (de.uni_bremen.st.rcf.model.Fragment g : f.getPredecessors()) {
                if (this.cancelled) break;
                int vID = g.getStart().getFile().getVersion().getClientId();
                int fID = g.isClientIdSet() ? g.getClientId() : g.getId();
                Fragment a = this.versions.get(vID).getFragment(fID);
                assert (a != null);
                ancestors.add(a);
            }
        }
        Fragment newF = null;
        newF = f.getStart().isOffsetSet() && f.getEnd().isOffsetSet() ? new Fragment(id, f.getStart().getLine(), f.getEnd().getLine(), f.getStart().getOffset(), f.getEnd().getOffset(), f.getNumTokens(), this.files.get(f.getStart().getFile().getId()), ancestors, newC) : new Fragment(id, f.getStart().getLine(), f.getEnd().getLine() + 1, -1, -1, f.getNumTokens(), this.files.get(f.getStart().getFile().getId()), ancestors, newC);
        assert (this.files.containsKey(f.getStart().getFile().getId()));
        this.files.get(f.getStart().getFile().getId()).addFragment(newF);
        newF.rcftuple = f;
        if (f.getRelation().hasAttribute("AlphabetSize") && f.isSet("AlphabetSize")) {
            newF.setAlphabetSize(f.getInt("AlphabetSize"));
        }
        return newF;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    protected void fireEnd() {
        for (ProgressListener pl : this.pListeners) {
            if (this.cancelled) {
                pl.cancelled();
                continue;
            }
            pl.finished();
        }
    }

    protected void fireProgressMade(double percent) {
        for (ProgressListener pl : this.pListeners) {
            pl.progressMade(percent);
        }
    }

    public CloneEvolutionGraph getCloneEvolutionGraph() {
        return this.cancelled ? null : this.ceg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    private boolean check(RCF rcf) {
        boolean usable = true;
        for (de.uni_bremen.st.rcf.model.Fragment f : rcf.getFragments()) {
            if (!f.getStart().isLineSet() || !f.getEnd().isLineSet()) {
                Console.error("Some fragments are missing attribute 'line'.");
                usable = false;
                break;
            }
            if (!f.getStart().isOffsetSet() || !f.getEnd().isOffsetSet()) {
                Console.warning("Some fragments are missing attribute 'offset'. This may lead to a certain imprecision.");
                break;
            }
            if (f.getStart().getOffset() >= 0 && f.getEnd().getOffset() > 0) continue;
            Console.error("Some fragments have an invalid value for attribute 'offset'. ");
            usable = false;
            break;
        }
        return usable;
    }
}

