/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.io;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.ui.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class SVNReader {
    private static final String REPOSITORY = "svn+ssh://pssvn.informatik.uni-stuttgart.de/projects/SVN/bauhaus/trunk/";
    private static final int width = 80;

    public static String getLog(String from, String to, String file) {
        while (from.startsWith("0")) {
            from = from.substring(1);
        }
        while (to.startsWith("0")) {
            to = to.substring(1);
        }
        file = REPOSITORY + file;
        Console.debug("svn log -v -r " + from + ":" + to + " " + file);
        String result = "";
        ProcessBuilder pb = new ProcessBuilder("svn", "log", "-v", "-r", from + ":" + to, file);
        try {
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                while (line.length() > 80) {
                    result = result + line.substring(0, 80) + "\n";
                    line = line.substring(80);
                }
                result = result + line + "\n";
                line = reader.readLine();
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            line = reader.readLine();
            while (line != null) {
                while (line.length() > 80) {
                    result = result + line.substring(0, 80) + "\n";
                    line = line.substring(80);
                }
                result = result + line + "\n";
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return result;
    }

    public static String getAuthors(CloneClass cc, String revision) {
        String result = "";
        while (revision.startsWith("0")) {
            revision = revision.substring(1);
        }
        for (Fragment f : cc.getFragments()) {
            HashMap<String, Integer> authors = new HashMap<String, Integer>();
            result = result + f.toString() + " ID: " + f.getID() + "\n";
            String file = REPOSITORY + f.getFile().substring(f.getVersion().getPath().length() + 1);
            Console.debug("svn blame -r " + revision + " " + file);
            ProcessBuilder pb = new ProcessBuilder("svn", "blame", "-r", revision, file);
            try {
                Process p = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = reader.readLine();
                int n = 0;
                while (line != null) {
                    if (++n < f.getStartLine()) continue;
                    if (n > f.getEndLine()) break;
                    String[] tokens = line.split("\\s+");
                    String name = tokens[2];
                    if (authors.containsKey(name)) {
                        authors.put(name, (Integer)authors.get(name) + 1);
                    } else {
                        authors.put(name, 1);
                    }
                    line = reader.readLine();
                }
                reader.close();
                reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                line = reader.readLine();
                while (line != null) {
                    while (line.length() > 80) {
                        result = result + line.substring(0, 80) + "\n";
                        line = line.substring(80);
                    }
                    result = result + line + "\n";
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e) {
                return e.getMessage();
            }
            for (Map.Entry e : authors.entrySet()) {
                result = result + "    " + (String)e.getKey() + "\t(" + e.getValue() + " lines)\n";
            }
        }
        return result;
    }

    public static String getAuthor(String revision) {
        while (revision.startsWith("0")) {
            revision = revision.substring(1);
        }
        ProcessBuilder pb = new ProcessBuilder("svn", "log", "-q", "-r", revision, REPOSITORY);
        try {
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("|")) {
                    String[] tokens = line.split("\\|");
                    reader.close();
                    return tokens[1].trim();
                }
                line = reader.readLine();
            }
            reader.close();
            String result = "";
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            line = reader.readLine();
            while (line != null) {
                while (line.length() > 80) {
                    result = result + line.substring(0, 80) + "\n";
                    line = line.substring(80);
                }
                result = result + line + "\n";
                line = reader.readLine();
            }
            reader.close();
            return result;
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

