/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.io.RCFManager;
import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.rcf.model.RCF;

public class ChangeFrequency
extends PlotData {
    public ChangeFrequency() {
        super("Change Frequency", PlotData.Type.BAR, "Change Frequency", "Genealogies");
    }

    @Override
    public boolean isAvailable() {
        RCF rcf = RCFManager.getCurrentRCF();
        return rcf.getCloneClasses().hasAttribute("Consistent") || rcf.getCloneClasses().hasAttribute("Inconsistent");
    }

    @Override
    protected void calculate() {
        int max = 0;
        double[] frequencies = new double[1024];
        for (Genealogy g : this.ceg.getGenealogies()) {
            int cf;
            if (!g.isVisible()) continue;
            int n = cf = g.getChangeFrequency();
            frequencies[n] = frequencies[n] + 1.0;
            max = cf > max ? cf : max;
        }
        this.data = new double[max + 1][2];
        for (int i = 0; i <= max; ++i) {
            this.data[i][0] = i;
            this.data[i][1] = frequencies[i];
        }
    }

    @Override
    public String[] getKey() {
        return new String[]{"Change Frequency"};
    }
}

