/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.io.RCFManager;
import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import java.util.Iterator;

public class DegreeOfChange
extends PlotData {
    public DegreeOfChange() {
        super("Degree of Change", PlotData.Type.BAR, "Version", "DC [%]");
    }

    @Override
    public String[] getKey() {
        if (this.ceg == null) {
            return new String[0];
        }
        return new String[]{"DC"};
    }

    @Override
    public boolean isAvailable() {
        RCF rcf = RCFManager.getCurrentRCF();
        if (!rcf.getVersions().hasAttribute("TotalTokens") || !rcf.getVersions().hasAttribute("ChangedTokens")) {
            return false;
        }
        for (Version v : rcf.getVersions()) {
            if (v.isSet("TotalTokens") && v.isSet("ChangedTokens")) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void calculate() {
        RCF rcf = RCFManager.getCurrentRCF();
        if (rcf == null) {
            this.data = null;
            return;
        }
        this.data = new double[this.ceg.getVersions().size()][2];
        Iterator vi = rcf.getVersions().iterator();
        int i = 0;
        while (vi.hasNext()) {
            Version v = (Version)vi.next();
            this.data[i][0] = i;
            this.data[i][1] = (double)v.getInt("ChangedTokens") / (double)v.getInt("TotalTokens") * 100.0;
            ++i;
        }
        if (this.data != null) {
            double sum = 0.0;
            for (int j = 0; j < this.data.length; ++j) {
                sum += this.data[j][1];
            }
            double avg = (double)Math.round(sum / (double)this.data.length * 100.0) / 100.0;
            Console.message("Average DC: " + avg + "%");
        }
    }
}

