/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.io.RCFManager;
import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.rcf.model.ProcessData;
import de.uni_bremen.st.rcf.model.RCF;
import java.util.HashMap;

public class ExecutionTime
extends PlotData {
    public ExecutionTime() {
        super("Execution Time", PlotData.Type.STACKED, "Version", "Time [ms]");
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public String[] getKey() {
        RCF rcf = RCFManager.getCurrentRCF();
        if (this.ceg == null || rcf == null) {
            return new String[0];
        }
        return new String[]{"token", "tree", "extract", "merge", "filter", "map", "output", "other"};
    }

    @Override
    protected void calculate() {
        RCF rcf = RCFManager.getCurrentRCF();
        if (rcf == null) {
            return;
        }
        if (this.getKey().length == 0) {
            this.data = null;
            return;
        }
        HashMap<String, Integer> times = new HashMap<String, Integer>();
        this.data = new double[this.ceg.getVersions().size()][this.getKey().length + 1];
        int v = -1;
        int totalVersion = 0;
        int totalTime = 0;
        for (ProcessData p : rcf.getProcessDatas()) {
            if (p.getPhaseName().equals("version")) {
                if (v >= 0) {
                    this.data[v][0] = v;
                    int total = 0;
                    for (int i = 0; i < this.getKey().length - 1; ++i) {
                        this.data[v][i + 1] = times.containsKey(this.getKey()[i]) ? (double)((Integer)times.get(this.getKey()[i])).intValue() : 0.0;
                        total = (int)((double)total + this.data[v][i + 1]);
                    }
                    this.data[v][this.getKey().length] = totalVersion - total;
                    times.clear();
                }
                ++v;
                totalVersion = Integer.parseInt(p.getString("totalReal").trim());
                totalTime += totalVersion;
                continue;
            }
            if (p.getPhaseName().equals("all")) continue;
            if (!p.isSet("selfReal")) {
                System.out.println("Not set for " + p.getPhaseName());
            }
            int time = Integer.parseInt(p.getString("selfReal").trim());
            if (times.containsKey(p.getPhaseName())) {
                times.put(p.getPhaseName(), (Integer)times.get(p.getPhaseName()) + time);
                continue;
            }
            times.put(p.getPhaseName(), time);
        }
        if (v >= 0) {
            this.data[v][0] = v;
            int total = 0;
            for (int i = 0; i < this.getKey().length - 1; ++i) {
                this.data[v][i + 1] = times.containsKey(this.getKey()[i]) ? (double)((Integer)times.get(this.getKey()[i])).intValue() : 0.0;
                total = (int)((double)total + this.data[v][i + 1]);
            }
            this.data[v][this.getKey().length] = totalVersion - total;
            times.clear();
        }
        Console.debug("Total time: " + totalTime);
    }
}

