/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.plot.PlotData;

public class GenealogyLifetime
extends PlotData {
    public GenealogyLifetime() {
        super("Genealogy Lifetime", PlotData.Type.BAR, "Versions", "Genealogies");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected void calculate() {
        int max = 1;
        double[] lifetimes = new double[this.ceg.getVersions().size()];
        for (Genealogy g : this.ceg.getGenealogies()) {
            if (!g.isVisible()) continue;
            int lt = g.getLifetime();
            int n = lt - 1;
            lifetimes[n] = lifetimes[n] + 1.0;
            max = lt > max ? lt : max;
        }
        this.data = new double[max][2];
        for (int i = 0; i < max; ++i) {
            this.data[i][0] = i + 1;
            this.data[i][1] = lifetimes[i];
        }
    }

    @Override
    public String[] getKey() {
        return new String[]{"Lifetime"};
    }
}

