/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.cyclone.system.Version;

public class LinesOfCode
extends PlotData {
    public LinesOfCode() {
        super("Lines of Code", PlotData.Type.GRAPH, "Version", "");
    }

    @Override
    protected void calculate() {
        if (this.ceg.getVersions().size() < 1) {
            this.data = null;
        } else {
            this.data = new double[this.ceg.getVersions().size()][3];
            int i = 0;
            for (Version v : this.ceg.getVersions()) {
                this.data[i][0] = i;
                this.data[i][1] = (double)v.getSource().getLOC() / 1000.0;
                this.data[i][2] = (double)v.getSource().getCLOC() / 1000.0;
                ++i;
            }
        }
    }

    @Override
    public String[] getKey() {
        if (this.ceg == null) {
            return new String[0];
        }
        return new String[]{"KLOC", "Cloned KLOC"};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

