/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.plot;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;

public abstract class PlotData
implements CloneEvolutionGraphListener,
Comparable<PlotData> {
    protected CloneEvolutionGraph ceg;
    private boolean update = true;
    protected double[][] data = null;
    private String name;
    private Type type;
    private String xLabel;
    private String yLabel;

    protected PlotData(String name, Type type, String xLabel, String yLabel) {
        assert (name != null);
        assert (type != null);
        assert (xLabel != null);
        assert (yLabel != null);
        this.name = name;
        this.type = type;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    protected abstract void calculate();

    public abstract boolean isAvailable();

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.ceg = g;
        this.update = true;
    }

    @Override
    public int compareTo(PlotData d) {
        return this.name.compareTo(d.getName());
    }

    public double[][] getData() {
        if (this.update && this.ceg != null) {
            this.calculate();
            this.update = false;
        }
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public abstract String[] getKey();

    public Type getType() {
        return this.type;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public static enum Type {
        BAR,
        STACKED,
        GRAPH;

    }
}

