/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.system;

import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.util.Counter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class Directory
extends Entity {
    private static final long serialVersionUID = 0L;

    public Directory(Entity parent, String path, Version version) {
        super(parent);
        this.path = path;
        this.depth = parent == null ? 1 : parent.getDepth() + 1;
        this.entities = new ArrayList();
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
    }

    public Directory(Entity parent, String path, Version revision, int depth, Counter c) {
        super(parent);
        this.path = path;
        this.depth = depth;
        this.entities = new ArrayList();
    }

    @Override
    public void calculate() {
        Collections.sort(this.entities);
        for (Entity e : this.entities) {
            e.calculate();
            this.loc += e.getLOC();
            this.cloc += e.getCLOC();
            this.fragments.addAll(e.getFragments());
        }
    }

    @Override
    public Set<SourceFile> getSourceFiles() {
        HashSet<SourceFile> s = new HashSet<SourceFile>();
        for (Entity e : this.entities) {
            s.addAll(e.getSourceFiles());
        }
        return s;
    }

    public int size() {
        return this.entities.size();
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public void paintForTreemap(GC gc, Rectangle r, boolean horizontal, int maxDepth) {
        int remainingSize;
        this.boundsTreemap.x = r.x;
        this.boundsTreemap.y = r.y;
        this.boundsTreemap.width = r.width;
        this.boundsTreemap.height = r.height;
        int x = r.x;
        int y = r.y;
        int remainingLoc = this.loc;
        int n = remainingSize = horizontal ? r.width : r.height;
        if (maxDepth > this.depth) {
            for (Entity e : this.entities) {
                if (horizontal) {
                    int width = (int)Math.round((double)e.getLOC() / (double)remainingLoc * (double)remainingSize);
                    e.paintForTreemap(gc, new Rectangle(x, y, width, r.height), false, maxDepth);
                    remainingSize -= width;
                    x += width;
                } else {
                    int height = (int)Math.round((double)e.getLOC() / (double)remainingLoc * (double)remainingSize);
                    e.paintForTreemap(gc, new Rectangle(x, y, r.width, height), true, maxDepth);
                    remainingSize -= height;
                    y += height;
                }
                remainingLoc -= e.getLOC();
            }
        } else {
            int value = Entity.metric.getValue(this) % 255;
            if (this.getSelected()) {
                gc.setBackground(new Color(gc.getDevice(), 255 - value, 255 - value, 255));
            } else if (this.getLinked()) {
                gc.setBackground(new Color(gc.getDevice(), 255 - value, 255, 255 - value));
            } else {
                gc.setBackground(new Color(gc.getDevice(), 255, 255 - value, 255 - value));
            }
            gc.fillRectangle(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paintOutline(GC gc, boolean dirs, boolean files, int maxDepth) {
        if (maxDepth > this.depth) {
            for (Entity e : this.entities) {
                e.paintOutline(gc, dirs, files, maxDepth);
            }
        }
        if (dirs) {
            gc.setForeground(gc.getDevice().getSystemColor(2));
            gc.drawRectangle(this.boundsTreemap.x, this.boundsTreemap.y, this.boundsTreemap.width, this.boundsTreemap.height);
        }
    }

    @Override
    public Entity getAt(int x, int y, int maxDepth) {
        if (!this.boundsTreemap.contains(x, y)) {
            return null;
        }
        if (maxDepth > this.depth) {
            Entity e;
            Entity s = null;
            Iterator i$ = this.entities.iterator();
            while (i$.hasNext() && (s = (e = (Entity)i$.next()).getAt(x, y, maxDepth)) == null) {
            }
            return s;
        }
        return this;
    }

    @Override
    public int getFileCount() {
        int c = 0;
        for (Entity e : this.entities) {
            c += e.getFileCount();
        }
        return c;
    }

    @Override
    public int getMaxDepth() {
        int max = 0;
        for (Entity e : this.entities) {
            max = Math.max(max, e.getMaxDepth());
        }
        return max + 1;
    }
}

