/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.system;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.treemap.CloneCoverage;
import de.uni_bremen.st.cyclone.ui.treemap.Metric;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class Entity
implements Comparable<Entity> {
    private static final long serialVersionUID = 0L;
    public static Metric metric = new CloneCoverage();
    protected String path;
    protected int loc = -1;
    protected int cloc = -1;
    protected Rectangle boundsTreemap = new Rectangle(0, 0, 0, 0);
    protected int depth = 0;
    protected List<Fragment> fragments = new LinkedList<Fragment>();
    private Map<Entity, LinkedList<CloneClass>> links = null;
    private boolean selected = false;
    private boolean linked = false;
    protected Entity parent = null;
    protected List<Entity> entities = null;

    public Entity(Entity parent) {
        this.parent = parent;
    }

    public String getPath() {
        return this.path;
    }

    public String getNativePath() {
        String result = this.path;
        result = result.replace('/', File.separatorChar);
        result = result.replace('\\', File.separatorChar);
        return result;
    }

    public abstract Set<SourceFile> getSourceFiles();

    public double getCloneCoverage() {
        return this.getLOC() == 0 ? 0.0 : (double)this.getCLOC() / (double)this.getLOC();
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public int getLOC() {
        return this.loc;
    }

    public int getCLOC() {
        int cloc = 0;
        if (this.entities != null) {
            for (Entity e : this.entities) {
                cloc += e.getCLOC();
            }
        } else {
            int lastEnd = 0;
            for (Fragment f : this.getVisibleFragments()) {
                if (f.getStartLine() > lastEnd) {
                    cloc += f.getEndLine() - f.getStartLine() + 1;
                } else if (f.getEndLine() > lastEnd) {
                    cloc += f.getEndLine() - lastEnd;
                }
                if (f.getEndLine() <= lastEnd) continue;
                lastEnd = f.getEndLine();
            }
        }
        return cloc;
    }

    @Override
    public int compareTo(Entity e) {
        return this.path.compareTo(e.getPath());
    }

    public abstract void calculate();

    public abstract int getFileCount();

    public abstract int getMaxDepth();

    public abstract void paintForTreemap(GC var1, Rectangle var2, boolean var3, int var4);

    public abstract void paintOutline(GC var1, boolean var2, boolean var3, int var4);

    public void paintLinks(GC gc, int minDepth, int maxDepth) {
        this.paintLinks(gc, minDepth, maxDepth, true);
    }

    public void paintLinks(GC gc, int minDepth, int maxDepth, boolean paintNumbers) {
        Point c = new Point(this.getCenterX(), this.getCenterY());
        for (Map.Entry<Entity, LinkedList<CloneClass>> e : this.links.entrySet()) {
            if (e.getKey().equals(this) || e.getKey().getDepth() <= minDepth) continue;
            int ecx = e.getKey().getCenterX();
            int ecy = e.getKey().getCenterY();
            gc.setForeground(new Color(gc.getDevice(), 192, 192, 192));
            gc.drawLine(c.x, c.y, ecx, ecy);
            gc.fillOval(c.x - 2, c.y - 2, 4, 4);
            gc.setForeground(gc.getDevice().getSystemColor(2));
            if (!paintNumbers) continue;
            gc.drawString("" + e.getValue().size(), ecx - 5, ecy - 15, true);
        }
    }

    public abstract Entity getAt(int var1, int var2, int var3);

    public int getCenterX() {
        return this.boundsTreemap.x + this.boundsTreemap.width / 2;
    }

    public int getCenterY() {
        return this.boundsTreemap.y + this.boundsTreemap.height / 2;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public List<Fragment> getVisibleFragments() {
        ArrayList<Fragment> list = new ArrayList<Fragment>();
        for (Fragment f : this.fragments) {
            if (!f.isVisible() || !f.getCloneClass().isVisible()) continue;
            list.add(f);
        }
        return list;
    }

    public void paintLinksRecursive(GC gc, int minDepth, int maxDepth) {
        if (this.getEntities() == null || this.getEntities().size() == 0 || this.getDepth() >= maxDepth) {
            this.calculateLinks(maxDepth, false);
            this.paintLinks(gc, minDepth, maxDepth, false);
        } else {
            for (Entity e : this.getEntities()) {
                e.paintLinksRecursive(gc, minDepth, maxDepth);
            }
        }
    }

    public void calculateLinks(int maxDepth, boolean setLinked) {
        this.links = new HashMap<Entity, LinkedList<CloneClass>>();
        for (Fragment fragment : this.getVisibleFragments()) {
            for (Fragment h : fragment.getCloneClass().getVisibleFragments()) {
                LinkedList<Object> ccs;
                if (h.equals(fragment) || h.getSourceFile() == null) continue;
                Entity e = h.getSourceFile();
                while (e.getDepth() > maxDepth) {
                    e = e.getParent();
                }
                if (e == null) continue;
                if (this.links.containsKey(e)) {
                    ccs = this.links.get(e);
                    if (((CloneClass)ccs.getLast()).equals(fragment.getCloneClass())) continue;
                    ccs.add(fragment.getCloneClass());
                    this.links.put(e, ccs);
                    continue;
                }
                ccs = new LinkedList<CloneClass>();
                ccs.add(fragment.getCloneClass());
                this.links.put(e, ccs);
                e.setLinked(setLinked);
            }
        }
        for (Map.Entry entry : this.links.entrySet()) {
            if (((Entity)entry.getKey()).equals(this)) continue;
            String result = ((Entity)entry.getKey()).getPath() + " (";
            Iterator i = ((LinkedList)entry.getValue()).iterator();
            result = result + ((CloneClass)i.next()).getID();
            while (i.hasNext()) {
                result = result + ", " + ((CloneClass)i.next()).getID();
            }
            result = result + ")";
            Console.message(result);
        }
    }

    public void select(int maxDepth) {
        this.selected = true;
        this.calculateLinks(maxDepth, true);
    }

    public void deselect() {
        this.selected = false;
        for (Entity e : this.links.keySet()) {
            e.setLinked(false);
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public int getDepth() {
        return this.depth;
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setLinked(boolean b) {
        this.linked = b;
    }

    public boolean getLinked() {
        return this.linked;
    }

    public int getNrOfFragments() {
        return this.getVisibleFragments().size();
    }
}

