/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.system;

import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.system.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SourceFile
extends Entity {
    private static final long serialVersionUID = 0L;
    private Version version;

    public SourceFile(Entity parent, String path, Version revision, int loc) {
        super(parent);
        this.version = revision;
        this.path = path;
        this.depth = parent.getDepth() + 1;
        this.loc = loc;
        this.fragments = new ArrayList();
    }

    public void addFragment(Fragment f) {
        this.fragments.add(f);
    }

    @Override
    public void calculate() {
        Collections.sort(this.fragments);
        int lastEnd = 0;
        for (Fragment f : this.fragments) {
            if (f.getStartLine() > lastEnd) {
                this.cloc += f.getEndLine() - f.getStartLine() + 1;
            } else if (f.getEndLine() > lastEnd) {
                this.cloc += f.getEndLine() - lastEnd;
            }
            if (f.getEndLine() <= lastEnd) continue;
            lastEnd = f.getEndLine();
        }
    }

    private void chooseColor(GC gc) {
        int value = Entity.metric.getValue(this) % 255;
        if (this.getSelected()) {
            gc.setBackground(new Color(gc.getDevice(), 255 - value, 255 - value, 255));
        } else if (this.getLinked()) {
            gc.setBackground(new Color(gc.getDevice(), 255 - value, 255, 255 - value));
        } else {
            gc.setBackground(new Color(gc.getDevice(), 255, 255 - value, 255 - value));
        }
    }

    @Override
    public Set<SourceFile> getSourceFiles() {
        HashSet<SourceFile> s = new HashSet<SourceFile>();
        s.add(this);
        return s;
    }

    @Override
    public void paintForTreemap(GC gc, Rectangle r, boolean horizontal, int maxDepth) {
        this.boundsTreemap.x = r.x;
        this.boundsTreemap.y = r.y;
        this.boundsTreemap.width = r.width;
        this.boundsTreemap.height = r.height;
        this.chooseColor(gc);
        gc.fillRectangle(r.x, r.y, r.width, r.height);
    }

    @Override
    public void paintOutline(GC gc, boolean dirs, boolean files, int maxDepth) {
        if (files) {
            gc.setForeground(new Color(gc.getDevice(), 224, 224, 224));
            gc.drawRectangle(this.boundsTreemap.x, this.boundsTreemap.y, this.boundsTreemap.width, this.boundsTreemap.height);
        }
    }

    @Override
    public int getFileCount() {
        return 1;
    }

    @Override
    public int getMaxDepth() {
        return 1;
    }

    @Override
    public Entity getAt(int x, int y, int maxDepth) {
        return this.boundsTreemap.contains(x, y) ? this : null;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getName() {
        String vp = this.version.getPath();
        boolean noTS = vp.length() > 0 && vp.charAt(vp.length() - 1) != File.separatorChar;
        return this.path.substring(vp.length() + (noTS ? 1 : 0));
    }
}

