/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.system;

import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.Genealogy;
import de.uni_bremen.st.cyclone.system.Directory;
import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.system.SourceFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Version
extends AbstractModelEntity {
    private Directory source = null;
    private Map<Integer, CloneClass> classes;
    private Map<Integer, Fragment> fragments;
    private String changesFilename;
    private String path;
    private Set<Genealogy> genealogies;
    private Version nextVersion = null;
    private Version previousVersion = null;

    public Directory getSource() {
        if (this.source == null) {
            // empty if block
        }
        return this.source;
    }

    public void setSource(Directory d) {
        this.source = d;
    }

    public Version(int id, String changesFilename, Version previousVersion) {
        super("Version");
        this.id = id;
        this.changesFilename = changesFilename;
        if (previousVersion != null) {
            this.previousVersion = previousVersion;
            previousVersion.setNextVersion(this);
        }
        this.path = changesFilename.substring(0, changesFilename.lastIndexOf("/"));
        this.classes = new HashMap<Integer, CloneClass>();
        this.fragments = new HashMap<Integer, Fragment>();
        this.genealogies = new HashSet<Genealogy>();
    }

    public void addCloneClass(CloneClass c) {
        for (Fragment f : c.getFragments()) {
            this.fragments.put(f.getID(), f);
        }
        this.classes.put(c.getID(), c);
    }

    public void addGenealogy(Genealogy g) {
        this.genealogies.add(g);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        return ((Version)o).getID() == this.id;
    }

    public CloneClass getCloneClass(int id) {
        return this.classes.get(id);
    }

    public String getChangesFilename() {
        return this.changesFilename;
    }

    public Map<Integer, CloneClass> getCloneClasses() {
        return this.classes;
    }

    public void setNextVersion(Version v) {
        this.nextVersion = v;
    }

    public Version next() {
        return this.nextVersion;
    }

    public Version previous() {
        return this.previousVersion;
    }

    public Map<Integer, CloneClass> getVisibleCloneClasses() {
        HashMap<Integer, CloneClass> m = new HashMap<Integer, CloneClass>();
        for (Integer i : this.classes.keySet()) {
            CloneClass c = this.classes.get(i);
            if (!c.isVisible()) continue;
            m.put(i, c);
        }
        return m;
    }

    public String getPath() {
        return this.path;
    }

    public Fragment getFragment(int id) {
        return this.fragments.get(id);
    }

    public Map<Integer, Fragment> getFragments() {
        return this.fragments;
    }

    public Map<Integer, Fragment> getVisibleFragments() {
        HashMap<Integer, Fragment> m = new HashMap<Integer, Fragment>();
        for (Integer i : this.fragments.keySet()) {
            Fragment f = this.fragments.get(i);
            if (!f.isVisible() || !f.getCloneClass().isVisible()) continue;
            m.put(i, f);
        }
        return m;
    }

    public int getNumberOfCloneClasses() {
        return this.classes.size();
    }

    public int getNumberOfFragments() {
        return this.fragments.size();
    }

    public SourceFile getFromPath(String p) {
        assert (p.startsWith(this.path));
        return (SourceFile)this.get(this.source, p);
    }

    private Entity get(Entity e, String s) {
        assert (e != null);
        if (e.getPath().equals(s)) {
            return e;
        }
        if (e.getEntities() != null) {
            for (Entity f : e.getEntities()) {
                assert (f != null);
                Entity result = this.get(f, s);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

