/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.Cyclone;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class Console {
    private static Display display = null;
    private static StyledText output = null;

    public static void initialize(Display newDisplay, StyledText newOutput) {
        display = newDisplay;
        output = newOutput;
        output.setEditable(false);
        output.setFont(new Font((Device)display, "Monospace", 10, 0));
    }

    public static boolean isInitialized() {
        return output != null;
    }

    public static void debug(String text) {
        assert (Console.isInitialized());
        Console.debug(text, false);
    }

    public static void message(String text) {
        assert (Console.isInitialized());
        Console.message(text, false);
    }

    public static void warning(String text) {
        assert (Console.isInitialized());
        Console.warning(text, false);
    }

    public static void error(String text) {
        assert (Console.isInitialized());
        Console.error(text, false);
    }

    public static void debug(final String text, final boolean timestamp) {
        assert (Console.isInitialized());
        if (Cyclone.isRelease()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (output != null) {
                    String time = timestamp ? System.currentTimeMillis() + " " : "";
                    output.append("DEBUG: " + time + text + "\n");
                    StyleRange sr = new StyleRange();
                    sr.start = output.getCharCount() - text.length() - time.length() - 8;
                    sr.length = 6;
                    sr.foreground = display.getSystemColor(9);
                    output.setStyleRange(sr);
                    Console.scrollToLastLine();
                }
            }
        });
    }

    public static void message(final String text, boolean timestamp) {
        assert (Console.isInitialized());
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (output != null) {
                    output.append(text + "\n");
                }
                Console.scrollToLastLine();
            }
        });
    }

    public static void warning(final String text, boolean timestamp) {
        assert (Console.isInitialized());
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (output != null) {
                    output.append("WARNING: " + text + "\n");
                    StyleRange sr = new StyleRange();
                    sr.start = output.getCharCount() - text.length() - 10;
                    sr.length = 8;
                    sr.foreground = display.getSystemColor(11);
                    output.setStyleRange(sr);
                    Console.scrollToLastLine();
                }
            }
        });
    }

    public static void error(final String text, boolean timestamp) {
        assert (Console.isInitialized());
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (output != null) {
                    output.append("ERROR: " + text + "\n");
                    StyleRange sr = new StyleRange();
                    sr.start = output.getCharCount() - text.length() - 8;
                    sr.length = 6;
                    sr.foreground = display.getSystemColor(3);
                    output.setStyleRange(sr);
                    Console.scrollToLastLine();
                }
            }
        });
    }

    private static void scrollToLastLine() {
        output.setCaretOffset(output.getCharCount());
        output.showSelection();
    }

    public static String ralign(String s, int digits) {
        String result = s;
        while (result.length() < digits) {
            result = " " + result;
        }
        return result;
    }

    public static String ralign(Number n, int digits) {
        return Console.ralign("" + n, digits);
    }

    public static String round(double n, int precision) {
        double mult = Math.pow(10.0, precision);
        int temp = (int)Math.round(n * mult);
        return "" + (double)temp / mult;
    }

    public static void clear() {
        assert (Console.isInitialized());
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (output != null) {
                    output.setText("");
                }
            }
        });
    }
}

