/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Filter;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.Controller;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.Dialog;
import de.uni_bremen.st.cyclone.ui.MenuDiff;
import de.uni_bremen.st.cyclone.ui.MenuFile;
import de.uni_bremen.st.cyclone.ui.MenuFilter;
import de.uni_bremen.st.cyclone.ui.MenuGraph;
import de.uni_bremen.st.cyclone.ui.MenuHelp;
import de.uni_bremen.st.cyclone.ui.MenuLayout;
import de.uni_bremen.st.cyclone.ui.evolution.EvolutionPanel;
import de.uni_bremen.st.cyclone.ui.graph.RelationCtrlPanel;
import de.uni_bremen.st.cyclone.ui.list.ListPanel;
import de.uni_bremen.st.cyclone.ui.plot.PlotCtrlPanel;
import de.uni_bremen.st.cyclone.ui.source.CompareSourcePanel;
import de.uni_bremen.st.cyclone.ui.treemap.SystemCtrlPanel;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CycloneFrame
implements CloneEvolutionGraphListener,
KeyListener {
    private static final long serialVersionUID = 0L;
    private MenuLayout menuLayout;
    private MenuDiff menuDiff;
    private MenuGraph menuGraph;
    private MenuFilter menuFilter;
    private List<Version> revisions;
    private EvolutionPanel ep;
    private PlotCtrlPanel pp;
    private CompareSourcePanel csp;
    private SystemCtrlPanel sp;
    private RelationCtrlPanel rp;
    private ListPanel lp;
    private Shell shell;
    private TabFolder tabs;
    private TabItem tabEvolution;
    private TabItem tabRelation;
    private TabItem tabSource;
    private Filter filter = new Filter();

    public CycloneFrame() {
        Display display = new Display();
        this.shell = new Shell(display);
        this.shell.setText("Cyclone");
        this.shell.setImage(CycloneFrame.getImage("cyclone.png"));
        this.shell.setMaximized(true);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Cyclone.saveConfig();
            }
        });
        SashForm form = new SashForm((Composite)this.shell, 512);
        this.tabs = new TabFolder((Composite)form, 2048);
        Console.initialize(display, new StyledText((Composite)form, 2816));
        form.setWeights(new int[]{80, 20});
        this.tabEvolution = new TabItem(this.tabs, 0);
        this.tabEvolution.setText("Evolution");
        this.tabEvolution.setImage(CycloneFrame.getImage("view-ceg.png"));
        this.ep = new EvolutionPanel(this.tabEvolution);
        Controller.addRevisionsListener(this.ep);
        Controller.addClassSelectionListener(this.ep);
        this.tabSource = new TabItem(this.tabs, 0);
        this.tabSource.setText("Source");
        this.tabSource.setImage(CycloneFrame.getImage("view-source.png"));
        this.csp = new CompareSourcePanel(this.tabSource);
        Controller.addRevisionsListener(this.csp);
        Controller.addClassSelectionListener(this.csp);
        TabItem tabSystem = new TabItem(this.tabs, 0);
        tabSystem.setText("System");
        tabSystem.setImage(CycloneFrame.getImage("view-system.png"));
        this.sp = new SystemCtrlPanel(tabSystem);
        Controller.addRevisionsListener(this.sp);
        if (!Cyclone.isRelease()) {
            this.tabRelation = new TabItem(this.tabs, 0);
            this.tabRelation.setText("Relation");
            this.tabRelation.setImage(CycloneFrame.getImage("view-relation.png"));
            this.rp = new RelationCtrlPanel(this.tabRelation);
            Controller.addRevisionsListener(this.rp);
            Controller.addClassSelectionListener(this.rp);
        }
        TabItem tabLists = new TabItem(this.tabs, 0);
        tabLists.setText("Lists");
        tabLists.setImage(CycloneFrame.getImage("view-list.png"));
        this.lp = new ListPanel(tabLists);
        Controller.addRevisionsListener(this.lp);
        Controller.addClassSelectionListener(this.lp);
        TabItem tabPlot = new TabItem(this.tabs, 0);
        tabPlot.setText("Plot");
        tabPlot.setImage(CycloneFrame.getImage("view-plot.png"));
        this.pp = new PlotCtrlPanel(tabPlot);
        Controller.addRevisionsListener(this.pp);
        Controller.addRevisionsListener(this);
        this.tabs.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0) {
                    if (CycloneFrame.this.revisions == null) {
                        return;
                    }
                    if (e.keyCode == 99) {
                        CycloneFrame.this.selectCloneClass();
                    } else if (e.keyCode == 102) {
                        CycloneFrame.this.selectFragment();
                    } else if (e.keyCode == 112) {
                        CycloneFrame.this.menuFilter.filterByPath(CycloneFrame.this.filter);
                    } else if (e.keyCode == 105) {
                        CycloneFrame.this.filter.invert();
                    }
                }
            }
        });
        this.tabs.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CycloneFrame.this.tabs.forceFocus();
            }
        });
        this.tabs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CycloneFrame.this.updateMenuVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Menu menuBar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menuBar);
        new MenuFile(menuBar, true);
        this.menuLayout = new MenuLayout(menuBar, false, this.ep);
        this.menuDiff = new MenuDiff(menuBar, false, this.csp);
        this.menuFilter = new MenuFilter(menuBar, false, this.filter);
        if (!Cyclone.isRelease()) {
            this.menuGraph = new MenuGraph(menuBar, false, this.rp);
        }
        new MenuHelp(menuBar, true);
        this.tabs.addKeyListener((KeyListener)this);
        Controller.addRevisionsListener(this.filter);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void updateMenuVisibility() {
        TabItem item = this.tabs.getSelection()[0];
        this.menuDiff.setEnabled(this.revisions != null && this.tabSource.equals(item));
        this.menuLayout.setEnabled(this.revisions != null && this.tabEvolution.equals(item));
        if (this.tabRelation != null) {
            this.menuGraph.setEnabled(this.revisions != null && this.tabRelation.equals(item));
        }
        this.menuFilter.setEnabled(this.revisions != null);
    }

    private void selectCloneClass() {
        int ccID = Dialog.getInt(this.shell, "Goto Clone Class", "Clone Class ID: ");
        if (ccID < 0) {
            return;
        }
        CloneClass cc = null;
        for (Version r : this.revisions) {
            if (!r.getVisibleCloneClasses().containsKey(ccID)) continue;
            cc = r.getVisibleCloneClasses().get(ccID);
            break;
        }
        if (cc != null) {
            Controller.classSelectionChanged(cc, this);
            this.ep.gotoCloneClass(cc);
        } else {
            Console.warning("Clone class with ID " + ccID + " not found");
        }
    }

    private void selectFragment() {
        int fID = Dialog.getInt(this.shell, "Goto Fragment", "Fragment ID: ");
        if (fID < 0) {
            return;
        }
        Collections.reverse(this.revisions);
        Fragment f = null;
        for (Version r : this.revisions) {
            if (!r.getVisibleFragments().containsKey(fID)) continue;
            f = r.getVisibleFragments().get(fID);
            break;
        }
        Collections.reverse(this.revisions);
        if (f != null) {
            Controller.fragmentSelectionChanged(f);
            Controller.classSelectionChanged(f.getCloneClass(), this);
            this.ep.gotoFragment(f);
        } else {
            Console.warning("Fragment with ID " + fID + " not found");
        }
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.revisions = g.getVersions();
        this.updateMenuVisibility();
    }

    public static Image getImage(String name) {
        name = "/" + name;
        if (Cyclone.class.getResource(name) == null) {
            System.err.println("ERROR: I cannot locate resource " + name);
            System.exit(0);
        }
        return new Image((Device)Display.getCurrent(), Cyclone.class.getResourceAsStream(name));
    }

    public void keyPressed(KeyEvent e) {
        if (this.revisions == null) {
            return;
        }
        TabItem item = this.tabs.getSelection()[0];
        if (e.character == '+') {
            if (this.tabEvolution.equals(item)) {
                this.ep.increaseZoom();
            } else if (this.tabRelation != null && this.tabRelation.equals(item)) {
                this.rp.getPanel().increaseZoom();
            }
        } else if (e.character == '-') {
            if (this.tabEvolution.equals(item)) {
                this.ep.decreaseZoom();
            } else if (this.tabRelation != null && this.tabRelation.equals(item)) {
                this.rp.getPanel().decreaseZoom();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

