/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.ui.CycloneFrame;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Dialog {
    private static final long serialVersionUID = 0L;
    private static int intResult;
    private static double doubleResult;
    private static String stringResult;
    private static boolean booleanResult;

    public static int getInt(Shell owner, String title, String message) {
        intResult = -1;
        final Shell dialog = new Shell(owner, 67616);
        dialog.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        dialog.setLayout((Layout)gl);
        Label label = new Label((Composite)dialog, 0);
        label.setText(message);
        label.setAlignment(131072);
        final Text text = new Text((Composite)dialog, 133124);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button ok = new Button((Composite)dialog, 8);
        ok.setText("OK");
        ok.setLayoutData((Object)new GridData(4, 4, true, true));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        Button cancel = new Button((Composite)dialog, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new GridData(4, 4, true, true));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                intResult = -1;
                dialog.dispose();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                try {
                    intResult = new Integer(text.getText());
                    ok.setEnabled(intResult >= 0);
                }
                catch (Exception e) {
                    ok.setEnabled(false);
                }
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && ok.isEnabled()) {
                    dialog.dispose();
                }
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
        return intResult;
    }

    public static Pair<String, Boolean> getStringBoolean(Shell owner, String title, String message, String boolLabel) {
        stringResult = null;
        booleanResult = false;
        final Shell dialog = new Shell(owner, 67616);
        dialog.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        gl.makeColumnsEqualWidth = true;
        dialog.setLayout((Layout)gl);
        Label label = new Label((Composite)dialog, 0);
        label.setText(message);
        label.setAlignment(131072);
        final Text text = new Text((Composite)dialog, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final Button check = new Button((Composite)dialog, 2080);
        check.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        check.setText(boolLabel);
        final Button ok = new Button((Composite)dialog, 8);
        ok.setText("OK");
        ok.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        Button cancel = new Button((Composite)dialog, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                stringResult = null;
                dialog.dispose();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                stringResult = text.getText();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && ok.isEnabled()) {
                    dialog.dispose();
                }
            }
        });
        check.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                booleanResult = check.getSelection();
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
        if (stringResult == null) {
            return null;
        }
        return new Pair<String, Boolean>(stringResult, booleanResult);
    }

    public static String getString(Shell owner, String title, String message) {
        stringResult = null;
        final Shell dialog = new Shell(owner, 67616);
        dialog.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        dialog.setLayout((Layout)gl);
        Label label = new Label((Composite)dialog, 0);
        label.setText(message);
        label.setAlignment(131072);
        final Text text = new Text((Composite)dialog, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button ok = new Button((Composite)dialog, 8);
        ok.setText("OK");
        ok.setLayoutData((Object)new GridData(4, 4, true, true));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        Button cancel = new Button((Composite)dialog, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new GridData(4, 4, true, true));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                stringResult = null;
                dialog.dispose();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                stringResult = text.getText();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && ok.isEnabled()) {
                    dialog.dispose();
                }
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
        return stringResult;
    }

    public static double getDouble(Shell owner, String title, String message, double min, double max) {
        final Shell dialog = new Shell(owner, 67616);
        dialog.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        dialog.setLayout((Layout)gl);
        Label label = new Label((Composite)dialog, 0);
        label.setText(message);
        label.setAlignment(131072);
        final Spinner spinner = new Spinner((Composite)dialog, 0);
        spinner.setDigits(2);
        spinner.setMinimum((int)(min * 100.0));
        spinner.setMaximum((int)(max * 100.0));
        spinner.setIncrement(10);
        spinner.setSelection(1);
        doubleResult = (double)spinner.getSelection() / 100.0;
        spinner.setLayoutData((Object)new GridData(4, 4, true, true));
        Button ok = new Button((Composite)dialog, 8);
        ok.setText("OK");
        ok.setLayoutData((Object)new GridData(4, 4, true, true));
        ok.setSelection(true);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        Button cancel = new Button((Composite)dialog, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new GridData(4, 4, true, true));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                doubleResult = -1.0;
                dialog.dispose();
            }
        });
        spinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                doubleResult = (double)spinner.getSelection() / 100.0;
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
        return doubleResult;
    }

    public static void showAboutDialog(Shell owner) {
        final Shell dialog = new Shell(owner, 67632);
        dialog.setText("About cyclone");
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.verticalSpacing = 12;
        gl.horizontalSpacing = 12;
        gl.marginLeft = 10;
        gl.marginRight = 10;
        gl.marginTop = 10;
        dialog.setLayout((Layout)gl);
        Label label = new Label((Composite)dialog, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        label.setText("cyclone");
        FontData font = Display.getCurrent().getSystemFont().getFontData()[0];
        font.setHeight(18);
        font.setStyle(1);
        label.setFont(new Font((Device)Display.getCurrent(), font));
        label = new Label((Composite)dialog, 131072);
        label.setImage(CycloneFrame.getImage("cyclone-large.png"));
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label = new Label((Composite)dialog, 64);
        label.setText("cyclone is a multi-perspective tool for inspecting\ncode clones and their evolution.");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        label = new Label((Composite)dialog, 16384);
        label.setText("Version:");
        label = new Label((Composite)dialog, 16384);
        label.setText(Cyclone.getVersion());
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        label = new Label((Composite)dialog, 16384);
        label.setText("Created on:");
        label = new Label((Composite)dialog, 16384);
        Calendar calender = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        label.setText(sdf.format(calender.getTime()));
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        label = new Label((Composite)dialog, 0x1000040);
        label.setText("Copyright \u00a9 2009-2011\nSoftware Engineering Group, University of Bremen, Germany");
        label.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        font = Display.getCurrent().getSystemFont().getFontData()[0];
        font.setHeight(8);
        label.setFont(new Font((Device)Display.getCurrent(), font));
        label = new Label((Composite)dialog, 0x1000000);
        label.setText("http://softwareclones.org");
        label.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 192));
        label.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Button ok = new Button((Composite)dialog, 8);
        ok.setText("   OK   ");
        ok.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 3, 1));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
    }

    public static void showMessageDialog(Shell owner, String title, String message) {
        final Shell dialog = new Shell(owner, 67632);
        dialog.setText(title);
        dialog.setSize(600, 400);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        dialog.setLayout((Layout)gl);
        Text text = new Text((Composite)dialog, 2626);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setEditable(false);
        text.setText(message);
        text.pack();
        Button ok = new Button((Composite)dialog, 8);
        ok.setText("   OK   ");
        ok.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                dialog.dispose();
            }
        });
        dialog.open();
        while (!dialog.isDisposed()) {
            if (dialog.getDisplay().readAndDispatch()) continue;
            dialog.getDisplay().sleep();
        }
    }

    public static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

