/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.Controller;
import de.uni_bremen.st.cyclone.io.RCFManager;
import de.uni_bremen.st.cyclone.ui.AbstractMenu;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.ProgressDialog;
import java.io.File;
import java.util.LinkedList;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuFile
extends AbstractMenu {
    private static final int MAX_NUMBER_OF_RECENT_FILES = 4;
    private LinkedList<MenuItem> recentFiles = new LinkedList();

    public MenuFile(Menu owner, boolean enabled) {
        super(owner, "&File", enabled);
        MenuItem menuItemOpen = new MenuItem(this.menu, 64);
        menuItemOpen.setText("&Open...");
        menuItemOpen.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MenuFile.this.actionFileOpen();
            }
        });
        MenuItem menuItemClearConsole = new MenuItem(this.menu, 64);
        menuItemClearConsole.setText("&Clear console");
        menuItemClearConsole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Console.clear();
            }
        });
        new MenuItem(this.menu, 258);
        new MenuItem(this.menu, 258);
        MenuItem menuItemClose = new MenuItem(this.menu, 64);
        menuItemClose.setText("&Quit");
        menuItemClose.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MenuFile.this.menu.getShell().close();
            }
        });
        this.updateRecentFileMenu();
    }

    public void actionFileOpen(String filename) {
        String result = filename;
        if (result == null) {
            FileDialog fd = new FileDialog(this.menu.getShell(), 4096);
            fd.setFilterPath(Cyclone.getConfig().getProperty("lastPath"));
            fd.setFilterNames(new String[]{"RCF", "ConQAT"});
            fd.setFilterExtensions(new String[]{"*.rcf", "*.xml"});
            result = fd.open();
        }
        if (result != null) {
            File file = new File(result);
            if (!file.canRead()) {
                Console.error("Can't read file \"" + file + "\"");
                return;
            }
            Cyclone.getConfig().setProperty("lastPath", file.getParent());
            Cyclone.saveConfig();
            RCFManager reader = new RCFManager();
            reader.setFile(file);
            new ProgressDialog(this.menu.getShell(), "Open file", reader);
            CloneEvolutionGraph cem = reader.getCloneEvolutionGraph();
            if (cem != null) {
                Controller.revisionsChanged(cem, null);
            }
            this.addRecentFile(result);
        }
    }

    public void actionFileOpen() {
        this.actionFileOpen(null);
    }

    private void updateRecentFileMenu() {
        for (MenuItem item : this.recentFiles) {
            item.dispose();
        }
        this.recentFiles.clear();
        String files = Cyclone.getConfig().getProperty("cyclone.recentFiles");
        if (files != null) {
            String[] fs;
            for (final String file : fs = files.split(File.pathSeparator)) {
                if (file.isEmpty()) continue;
                MenuItem item = new MenuItem(this.menu, 64, this.menu.getItemCount() - 2);
                item.setText(file);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        MenuFile.this.actionFileOpen(file);
                    }
                });
                this.recentFiles.add(item);
            }
        }
    }

    public void addRecentFile(String filename) {
        String[] fs;
        this.removeRecentFile(filename);
        String files = Cyclone.getConfig().getProperty("cyclone.recentFiles");
        if (files != null && (fs = files.split(File.pathSeparator)).length >= 4) {
            files = "";
            int n = 0;
            boolean first = true;
            for (String file : fs) {
                if (++n == 4) break;
                if (file.isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    files = files + File.pathSeparator;
                }
                files = files + file;
            }
        }
        if (files != null && !files.isEmpty()) {
            if (!files.contains(filename)) {
                files = filename + File.pathSeparator + files;
            }
        } else {
            files = filename;
        }
        Cyclone.getConfig().setProperty("cyclone.recentFiles", files);
        Cyclone.saveConfig();
        this.updateRecentFileMenu();
    }

    public void removeRecentFile(String filename) {
        String files = Cyclone.getConfig().getProperty("cyclone.recentFiles");
        if (files != null) {
            StringBuilder s = new StringBuilder();
            String[] fs = files.split(File.pathSeparator);
            boolean first = true;
            for (String file : fs) {
                if (file.equals(filename)) continue;
                if (first) {
                    first = false;
                } else {
                    s.append(File.pathSeparator);
                }
                s.append(file);
            }
            Cyclone.getConfig().setProperty("cyclone.recentFiles", s.toString());
            Cyclone.saveConfig();
        }
    }
}

