/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.Filter;
import de.uni_bremen.st.cyclone.ui.AbstractMenu;
import de.uni_bremen.st.cyclone.ui.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuFilter
extends AbstractMenu {
    public MenuFilter(Menu owner, boolean enabled, final Filter filter) {
        super(owner, "&Filter", enabled);
        MenuItem menuItemFilterStatic = new MenuItem(this.menu, 64);
        menuItemFilterStatic.setText("&Static");
        menuItemFilterStatic.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                filter.removeStaticGenealogies();
            }
        });
        MenuItem menuItemFilterExcessive = new MenuItem(this.menu, 64);
        menuItemFilterExcessive.setText("&Excessive");
        menuItemFilterExcessive.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                filter.removeExcessiveGenealogies();
            }
        });
        if (!Cyclone.isRelease()) {
            MenuItem menuItemFilterSingleModule = new MenuItem(this.menu, 64);
            menuItemFilterSingleModule.setText("Single &Module");
            menuItemFilterSingleModule.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    filter.removeSingleModuleGenealogies();
                }
            });
        }
        MenuItem menuItemFilterPath = new MenuItem(this.menu, 64);
        menuItemFilterPath.setText("By &Path...");
        menuItemFilterPath.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MenuFilter.this.filterByPath(filter);
            }
        });
        new MenuItem(this.menu, 258);
        MenuItem menuItemFilterInvert = new MenuItem(this.menu, 64);
        menuItemFilterInvert.setText("&Invert");
        menuItemFilterInvert.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                filter.invert();
            }
        });
        MenuItem menuItemFilterReset = new MenuItem(this.menu, 64);
        menuItemFilterReset.setText("&Reset");
        menuItemFilterReset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                filter.reset();
            }
        });
    }

    public void filterByPath(Filter filter) {
        Dialog.Pair<String, Boolean> path = Dialog.getStringBoolean(this.menu.getShell(), "Filter by Path", "Expression:", "Invert");
        if (path != null) {
            filter.removeGenealogiesByPath((String)path.a, (Boolean)path.b);
        }
    }
}

