/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui;

import de.uni_bremen.st.cyclone.control.ProgressListener;
import de.uni_bremen.st.cyclone.util.Worker;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressDialog
implements ProgressListener {
    private static final long serialVersionUID = 0L;
    private Shell dialog;
    private Label label;
    private ProgressBar bar;
    private Button cancel;

    public ProgressDialog(Shell owner, String title, final Worker worker) {
        this.dialog = new Shell(owner, 67616);
        this.dialog.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.dialog.setLayout((Layout)gl);
        this.label = new Label((Composite)this.dialog, 0);
        this.label.setLayoutData((Object)new GridData(4, 2, true, false));
        this.bar = new ProgressBar((Composite)this.dialog, 65536);
        this.bar.setMinimum(0);
        this.bar.setMaximum(100);
        this.cancel = new Button((Composite)this.dialog, 8);
        this.cancel.setText("&Cancel");
        this.cancel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                worker.cancel();
            }
        });
        worker.addProgressListener(this);
        new Thread(worker).start();
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    @Override
    public void progressMade(final double percent) {
        this.dialog.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.bar.setSelection((int)(percent * 100.0));
                ProgressDialog.this.dialog.getDisplay().wake();
            }
        });
    }

    public void disposeDialog() {
        this.dialog.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.dialog.dispose();
            }
        });
    }

    @Override
    public void finished() {
        this.disposeDialog();
    }

    @Override
    public void cancelled() {
        this.disposeDialog();
    }

    @Override
    public void setTaskDescription(final String s) {
        this.dialog.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.label.setText(s);
                ProgressDialog.this.dialog.getDisplay().wake();
            }
        });
    }
}

