/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.evolution;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.Controller;
import de.uni_bremen.st.cyclone.control.FragmentSelectionListener;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.evolution.Highlight;
import de.uni_bremen.st.cyclone.ui.graph.GraphPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabItem;

public class EvolutionPanel
extends GraphPanel
implements FragmentSelectionListener,
ClassSelectionListener,
CloneEvolutionGraphListener,
MouseListener,
MouseMoveListener {
    private static final long serialVersionUID = 0L;
    private final int SPACE = 2;
    private final int D = 4;
    private final int SPACE_REVISION = 20;
    private boolean extPosCalc = true;
    private final Color COLOR_TYPE2 = new Color((Device)this.getDisplay(), 128, 128, 128);
    private final Color COLOR_TYPE3 = new Color((Device)this.getDisplay(), 192, 192, 192);
    private final Color COLOR_CONSISTENT = new Color((Device)this.getDisplay(), 200, 200, 200);
    private final Color COLOR_INCONSISTENT = new Color((Device)this.getDisplay(), 100, 100, 100);
    private final Color COLOR_SELECTED = new Color((Device)this.getDisplay(), 250, 200, 200);
    private final Color COLOR_CONSISTENT_SELECTED = new Color((Device)this.getDisplay(), 200, 120, 120);
    private final Color COLOR_INCONSISTENT_SELECTED = new Color((Device)this.getDisplay(), 255, 50, 50);
    private final Color COLOR_INFO = new Color((Device)this.getDisplay(), 245, 245, 255);
    private final Color COLOR_ID_BACKGROUND = new Color((Device)this.getDisplay(), 128, 128, 128);
    private List<CloneClass> classesInView = new ArrayList<CloneClass>();
    private List<Fragment> fragmentsInView = new ArrayList<Fragment>();
    private CloneClass infoClass = null;
    private Point mousePosition;

    public EvolutionPanel(TabItem owner) {
        super((Composite)owner.getParent());
        owner.setControl((Control)this);
    }

    @Override
    protected void paint(Rectangle rect, GC gc) {
        this.classesInView.clear();
        this.fragmentsInView.clear();
        if (this.ceg != null) {
            gc.setForeground(this.COLOR_DEFAULT);
            int y = 8 * this.zoom;
            for (Version r : this.ceg.getVersions()) {
                if (y + 20 * this.zoom < rect.y) {
                    y += 20 * this.zoom;
                    continue;
                }
                for (CloneClass c : r.getVisibleCloneClasses().values()) {
                    if (!c.isVisible()) continue;
                    Rectangle cr = c.getBounds();
                    int frags = c.getVisibleFragments().size();
                    int wClass = (frags * 4 + (frags + 1) * 2) * this.zoom;
                    if (!rect.intersects(new Rectangle(cr.x - 1, cr.y - 1, wClass + 2, 8 * this.zoom + 2))) continue;
                    this.classesInView.add(c);
                    if (c.isConsistentlyChanged()) {
                        if (c.isMarked()) {
                            gc.setBackground(this.COLOR_CONSISTENT_SELECTED);
                        } else {
                            gc.setBackground(this.COLOR_CONSISTENT);
                        }
                    } else if (c.isInconsistentlyChanged()) {
                        if (c.isMarked()) {
                            gc.setBackground(this.COLOR_INCONSISTENT_SELECTED);
                        } else {
                            gc.setBackground(this.COLOR_INCONSISTENT);
                        }
                    } else if (c.isMarked()) {
                        gc.setBackground(this.COLOR_SELECTED);
                    } else {
                        gc.setBackground(this.COLOR_BACKGROUND);
                    }
                    gc.fillRectangle(cr.x, cr.y, wClass, 8 * this.zoom);
                    if (c.getType() == 2) {
                        gc.setForeground(this.COLOR_TYPE2);
                    } else if (c.getType() == 3) {
                        gc.setForeground(this.COLOR_TYPE3);
                    } else {
                        gc.setForeground(this.COLOR_DEFAULT);
                    }
                    gc.drawRectangle(cr.x, cr.y, wClass, 8 * this.zoom);
                    gc.setForeground(this.COLOR_DEFAULT);
                    for (Fragment f : c.getVisibleFragments()) {
                        for (Fragment p : f.getAncestors()) {
                            int x1 = p.getBounds().x + 2 * this.zoom;
                            int y1 = p.getBounds().y + 2 * this.zoom;
                            int x2 = f.getBounds().x + 2 * this.zoom;
                            int y2 = f.getBounds().y + 2 * this.zoom;
                            gc.drawLine(x1, y1, x2, y2);
                            this.drawFragment(p, gc);
                        }
                        if (f.getDescendant() != null) {
                            Fragment p = f.getDescendant();
                            int x1 = p.getBounds().x + 2 * this.zoom;
                            int y1 = p.getBounds().y + 2 * this.zoom;
                            int x2 = f.getBounds().x + 2 * this.zoom;
                            int y2 = f.getBounds().y + 2 * this.zoom;
                            gc.drawLine(x1, y1, x2, y2);
                            if (!rect.contains(p.getBounds().x, p.getBounds().y)) {
                                this.drawFragment(f, gc);
                            }
                        }
                        if (f.getDescendant() != null) continue;
                        this.drawFragment(f, gc);
                    }
                }
                if ((y += 20 * this.zoom) - 8 * this.zoom <= rect.y + rect.height) continue;
                break;
            }
            if (this.infoClass != null) {
                int space;
                Rectangle re = this.infoClass.getBounds();
                int ix = re.x + re.width + 20;
                int iy = re.y + re.height + 20;
                int maxX = space = 12;
                ArrayList<String> text = new ArrayList<String>();
                String s = this.infoClass.toString();
                maxX = Math.max(maxX, gc.textExtent((String)s).x);
                text.add(s);
                s = this.infoClass.getRevision().getPath();
                maxX = Math.max(maxX, gc.textExtent((String)s).x);
                text.add(s);
                text.add("");
                for (Fragment f : this.infoClass.getVisibleFragments()) {
                    String file = f.getRelativeFilePath();
                    if (file.startsWith("/") || file.startsWith("\\")) {
                        file = file.substring(1);
                    }
                    s = f.getID() + "  " + file + "  " + f.getStartLine() + "  " + f.getEndLine();
                    maxX = Math.max(maxX, gc.textExtent((String)s).x);
                    text.add(s);
                }
                ix = re.x + re.width + 20 + space;
                iy = re.y + re.height + 20;
                if (ix + maxX + 2 * space > rect.x + rect.width) {
                    ix = re.x - 20 - space - (maxX + 2 * space);
                }
                if (ix < rect.x + re.width) {
                    ix = rect.x + rect.width - 10 - (maxX + 2 * space);
                }
                if (iy + (text.size() + 1) * space > rect.y + rect.height) {
                    iy = re.y - 20 - (text.size() + 1) * space;
                }
                gc.setBackground(this.COLOR_INFO);
                gc.fillRectangle(ix, iy, maxX + 2 * space, (text.size() + 1) * space);
                gc.setForeground(this.COLOR_DEFAULT);
                gc.drawRectangle(ix, iy, maxX + 2 * space, (text.size() + 1) * space);
                iy = (int)((double)iy - (double)space / 1.5);
                for (String t : text) {
                    gc.drawString(t, ix + space, iy += space, true);
                }
            }
            Font oldFont = gc.getFont();
            FontData[] fd = oldFont.getFontData();
            fd[0].setHeight((int)(5.0f * (float)this.zoom));
            gc.setFont(new Font((Device)this.getDisplay(), fd));
            int textWidth = this.ceg.getVersions().isEmpty() ? 0 : gc.textExtent((String)new StringBuilder().append((int)this.ceg.getVersions().get((int)(this.ceg.getVersions().size() - 1)).getID()).append((String)"").toString()).x;
            gc.setBackground(this.COLOR_ID_BACKGROUND);
            gc.fillRectangle(rect.x, rect.y, textWidth + 8 * this.zoom, rect.height);
            gc.setForeground(this.COLOR_TYPE3);
            int x = rect.x + textWidth + 4 * this.zoom;
            y = 20 * this.zoom / 2;
            for (Version r : this.ceg.getVersions()) {
                gc.drawString("" + r.getID(), x - gc.textExtent((String)new StringBuilder().append((String)"").append((int)r.getID()).toString()).x, y);
                y += 20 * this.zoom;
            }
            gc.setFont(oldFont);
        }
    }

    private void drawFragment(Fragment f, GC gc) {
        if (f.isMarked()) {
            gc.setBackground(this.COLOR_SELECTED);
        } else {
            gc.setBackground(this.COLOR_BACKGROUND);
        }
        Rectangle b = f.getBounds();
        gc.fillOval(b.x, b.y, b.width, b.height);
        gc.setForeground(this.COLOR_DEFAULT);
        gc.drawOval(b.x, b.y, b.width, b.height);
        this.fragmentsInView.add(f);
    }

    public void setExtPosCalc(boolean b) {
        this.extPosCalc = b;
        this.calculatePositions();
    }

    private boolean hasParent(CloneClass cc) {
        for (Fragment f : cc.getFragments()) {
            Fragment parent;
            List<Fragment> parents = f.getAncestors();
            if (parents.isEmpty() || (parent = parents.get(0)) == null) continue;
            return true;
        }
        return false;
    }

    private Collection<CloneClass> getDescendants(CloneClass cc) {
        TreeMap<Integer, CloneClass> descendants = new TreeMap<Integer, CloneClass>();
        for (Fragment f : cc.getFragments()) {
            if (f.getDescendant() == null) continue;
            CloneClass ccD = f.getDescendant().getCloneClass();
            descendants.put(ccD.getID(), ccD);
        }
        return descendants.values();
    }

    @Override
    public void calculatePositions() {
        int maxWidth = this.getBounds().width;
        int maxHeight = this.getBounds().height;
        int xClass = 34 * this.zoom;
        int yClass = 20 * this.zoom / 2;
        int ccNr = 0;
        if (this.ceg != null) {
            if (this.extPosCalc) {
                LinkedList<CloneClass> firstClasses = new LinkedList<CloneClass>();
                if (this.ceg.getVersions().size() < 1) {
                    return;
                }
                int firstRevision = this.ceg.getVersions().get(0).getID();
                for (Version r : this.ceg.getVersions()) {
                    for (CloneClass cc : r.getVisibleCloneClasses().values()) {
                        cc.setBounds(null);
                        if (this.hasParent(cc)) continue;
                        firstClasses.add(cc);
                    }
                    ccNr += r.getNumberOfCloneClasses();
                }
                Collections.sort(firstClasses);
                Collections.reverse(firstClasses);
                xClass = 34 * this.zoom;
                int maxX = 0;
                int i = 0;
                for (CloneClass cc : firstClasses) {
                    ++i;
                    int ccI = 0;
                    int[] ret = this.arrange(cc, xClass, firstRevision, ccI);
                    maxX = Math.max(maxX, ret[0]);
                    maxWidth = Math.max(maxWidth, ret[1]);
                    maxHeight = Math.max(maxHeight, ret[2]);
                    ccI = ret[3];
                    xClass = maxX + 2 * this.zoom;
                    ccNr += ccI;
                }
                for (Version r : this.ceg.getVersions()) {
                    for (CloneClass cc : r.getVisibleCloneClasses().values()) {
                        if (cc.getBounds() != null) continue;
                        cc.setBounds(new Rectangle(-100, -100, 1, 1));
                    }
                }
            } else {
                for (Version r : this.ceg.getVersions()) {
                    ArrayList<CloneClass> classes = new ArrayList<CloneClass>(r.getVisibleCloneClasses().values());
                    Collections.sort(classes);
                    for (CloneClass c : classes) {
                        int frags = c.getFragments().size();
                        int wClass = (frags * 4 + (frags + 1) * 2) * this.zoom;
                        c.setBounds(new Rectangle(xClass, yClass, wClass, 8 * this.zoom));
                        int xFragment = xClass + 2 * this.zoom;
                        int yFragment = yClass + 2 * this.zoom;
                        if (xFragment == 0 && yFragment == 0) {
                            System.out.println("ARGH");
                            System.exit(0);
                        }
                        for (Fragment f : c.getVisibleFragments()) {
                            f.setBounds(new Rectangle(xFragment, yFragment, 4 * this.zoom, 4 * this.zoom));
                            xFragment += 6 * this.zoom;
                        }
                        maxWidth = maxWidth >= xClass + 4 * this.zoom ? maxWidth : xClass + (4 + wClass) * this.zoom;
                        xClass += wClass + 2 * this.zoom;
                    }
                    xClass = 34 * this.zoom;
                    yClass += 20 * this.zoom;
                    ccNr += r.getNumberOfCloneClasses();
                }
                maxHeight = yClass;
            }
            this.canvas.setSize(Math.max(maxWidth, this.getSize().x), Math.max(maxHeight, this.getSize().y));
            this.canvas.redraw();
        }
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.ceg = g;
        this.calculatePositions();
    }

    private int[] arrange(CloneClass cc, int xClass, int firstRevision, int ccI) {
        int rID = cc.getRevision().getID();
        int frags = cc.getVisibleFragments().size();
        int wClass = (frags * 4 + (frags + 1) * 2) * this.zoom;
        int yClass = (rID - firstRevision) * 20 * this.zoom + 2 * this.zoom;
        int maxWidth = xClass + (4 + wClass) * this.zoom;
        int maxHeight = (yClass += 20 * this.zoom / 3) + 12 * this.zoom;
        int maxX = xClass + wClass;
        if (cc.getBounds() == null) {
            cc.setBounds(new Rectangle(xClass, yClass, wClass, 8 * this.zoom));
            this.relocateFragments(cc);
            CloneClass[] descendants = this.getDescendants(cc).toArray(new CloneClass[0]);
            for (int i = descendants.length - 1; i >= 0; --i) {
                int[] max = this.arrange(descendants[i], i == 0 ? xClass : maxX + 2 * this.zoom, firstRevision, ccI);
                maxX = Math.max(max[0], maxX);
                maxWidth = Math.max(max[1], maxWidth);
                maxHeight = Math.max(max[2], maxHeight);
                ccI = max[3];
            }
        }
        return new int[]{maxX, maxWidth, maxHeight, ccI + 1};
    }

    private void relocateFragments(CloneClass cc) {
        Rectangle ccRect = cc.getBounds();
        int x = ccRect.x + 2 * this.zoom;
        int y = ccRect.y + 2 * this.zoom;
        for (Fragment f : cc.getVisibleFragments()) {
            f.setBounds(new Rectangle(x, y, 4 * this.zoom, 4 * this.zoom));
            x += 6 * this.zoom;
        }
    }

    private Fragment getFragment(Point p) {
        for (Fragment f : this.fragmentsInView) {
            if (!f.getBounds().contains(p)) continue;
            return f;
        }
        return null;
    }

    private CloneClass getClass(Point p) {
        for (CloneClass cc : this.classesInView) {
            if (!cc.getBounds().contains(p)) continue;
            return cc;
        }
        return null;
    }

    public void gotoCloneClass(CloneClass cc) {
        if (cc != null) {
            Rectangle ccB = cc.getBounds();
            int ccX = ccB.x + ccB.width / 2;
            int ccY = ccB.y + ccB.height / 2;
            this.setOrigin(ccX - this.getClientArea().width / 2, ccY - this.getClientArea().height / 2);
            this.canvas.redraw();
        }
    }

    public void gotoFragment(Fragment f) {
        if (f != null) {
            while (f.getDescendant() != null && f.getDescendant().getID() == f.getID()) {
                f = f.getDescendant();
            }
            Highlight.highlight(f);
            this.setOrigin(f.getBounds().x - this.getClientArea().width / 2, f.getBounds().y - this.getClientArea().height / 2);
            this.canvas.redraw();
        }
    }

    public void mouseDown(MouseEvent e) {
        Highlight.clearHighlight();
        Fragment frag = this.getFragment(this.mousePosition);
        if (frag != null) {
            if (e.button == 1) {
                Highlight.highlight(frag);
            } else if (e.button == 2) {
                Highlight.highlightGenealogy(frag);
            }
            this.canvas.redraw();
            return;
        }
        CloneClass cc = this.getClass(this.mousePosition);
        if (cc != null) {
            if (e.button == 1) {
                Controller.classSelectionChanged(cc, null);
            } else if (e.button == 2) {
                Highlight.highlightGenealogy(cc);
            } else if (e.button == 3) {
                Highlight.highlight(cc);
            }
            this.canvas.redraw();
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        Highlight.clearHighlight();
        CloneClass cc = this.getClass(new Point(e.x, e.y));
        if (cc != null) {
            if (e.button == 1) {
                Controller.classSelectionChanged(cc, null);
            }
            this.canvas.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        this.mousePosition = new Point(e.x, e.y);
        CloneClass cc = this.getClass(this.mousePosition);
        this.infoClass = null;
        if (cc != null) {
            this.infoClass = cc;
        }
        this.canvas.redraw();
    }

    @Override
    public void classSelectionChanged(CloneClass cc) {
        Highlight.clearHighlight();
        Highlight.highlight(cc);
        this.canvas.redraw();
    }

    @Override
    public void fragmentSelectionChanged(Fragment f) {
        Highlight.clearHighlight();
        Highlight.highlight(f);
        this.canvas.redraw();
    }
}

