/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.evolution;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.Fragment;
import java.util.ArrayList;
import java.util.List;

public class Highlight {
    private static List<Fragment> highlightedFragments = new ArrayList<Fragment>();
    private static List<CloneClass> highlightedClasses = new ArrayList<CloneClass>();

    public static void highlightGenealogy(Fragment f) {
        if (f.isMarked()) {
            return;
        }
        f.mark();
        highlightedFragments.add(f);
        for (Fragment a : f.getAncestors()) {
            Highlight.highlightGenealogy(a);
        }
        if (f.getDescendant() != null) {
            Highlight.highlightGenealogy(f.getDescendant());
        }
    }

    public static void highlightGenealogy(CloneClass cc) {
        Highlight.clearHighlight();
        for (CloneClass c : cc.getGenealogy().getCloneClasses()) {
            highlightedClasses.add(c);
            c.mark();
        }
    }

    public static void clearHighlight() {
        for (CloneClass c : highlightedClasses) {
            c.unmark();
        }
        highlightedClasses.clear();
        for (Fragment f : highlightedFragments) {
            f.unmark();
        }
        highlightedFragments.clear();
    }

    public static void highlight(CloneClass cc) {
        Highlight.clearHighlight();
        cc.mark();
        highlightedClasses.add(cc);
    }

    public static void highlight(Fragment f) {
        Highlight.clearHighlight();
        f.mark();
        highlightedFragments.add(f);
    }
}

