/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import de.uni_bremen.st.cyclone.ui.graph.SingleVersionGraphGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CloneGraph
extends SingleVersionGraphGenerator {
    public CloneGraph() {
        super("Clones between files");
    }

    @Override
    public Graph generateGraph(CloneEvolutionGraph ceg) {
        Node n;
        HashMap<SourceFile, Node> fileNodes = new HashMap<SourceFile, Node>();
        Graph graph = new Graph();
        int fC = 0;
        Set<SourceFile> sourceFiles = ceg.getVersions().get(this.getVersionNumber()).getSource().getSourceFiles();
        int numFiles = sourceFiles.size() * 3;
        for (SourceFile f : sourceFiles) {
            this.fireProgressMade((double)fC / (double)numFiles);
            if (this.isCancelled()) {
                return null;
            }
            ++fC;
            n = new Node(f);
            graph.addNode(n);
            fileNodes.put(f, n);
        }
        for (SourceFile file : sourceFiles) {
            this.fireProgressMade((double)fC / (double)numFiles);
            if (this.isCancelled()) {
                return null;
            }
            ++fC;
            n = (Node)fileNodes.get(file);
            assert (n != null);
            for (Fragment f : file.getFragments()) {
                for (Fragment g : f.getCloneClass().getFragments()) {
                    if (g.getSourceFile().equals(file)) continue;
                    graph.addEdge(new Edge(n, (Node)fileNodes.get(g.getSourceFile()), this.getWeight(file, g.getSourceFile())));
                }
            }
        }
        for (Node n2 : graph.getNodes()) {
            this.fireProgressMade((double)fC / (double)numFiles);
            if (this.isCancelled()) {
                return null;
            }
            ++fC;
            n2.setValue("" + n2.getEdges().size());
        }
        return graph;
    }

    private double getWeight(SourceFile a, SourceFile b) {
        double loc = a.getLOC() + b.getLOC();
        ArrayList<Fragment> fragmentsA = new ArrayList<Fragment>();
        ArrayList<Fragment> fragmentsB = new ArrayList<Fragment>();
        block0: for (Fragment f : a.getFragments()) {
            for (Fragment g : f.getCloneClass().getFragments()) {
                if (!g.getSourceFile().equals(b)) continue;
                for (Fragment h : f.getCloneClass().getFragments()) {
                    if (h.getSourceFile().equals(a)) {
                        fragmentsA.add(h);
                        continue;
                    }
                    if (!h.getSourceFile().equals(b)) continue;
                    fragmentsB.add(h);
                }
                continue block0;
            }
        }
        double cloc = this.getCLOC(fragmentsA) + this.getCLOC(fragmentsB);
        return loc > 0.0 ? cloc / loc : 0.0;
    }

    private int getCLOC(List<Fragment> fragments) {
        Collections.sort(fragments, new Comparator<Fragment>(){

            @Override
            public int compare(Fragment a, Fragment b) {
                if (a.getStartLine() != b.getEndLine()) {
                    return a.getStartLine() < b.getStartLine() ? -1 : 1;
                }
                if (a.getEndLine() == b.getEndLine()) {
                    return 0;
                }
                return a.getEndLine() < b.getEndLine() ? -1 : 1;
            }
        });
        int cloc = 0;
        int lastEnd = 0;
        for (Fragment f : fragments) {
            if (f.getStartLine() > lastEnd) {
                cloc += f.getEndLine() - f.getStartLine() + 1;
            } else if (f.getEndLine() > lastEnd) {
                cloc += f.getEndLine() - lastEnd;
            }
            if (f.getEndLine() <= lastEnd) continue;
            lastEnd = f.getEndLine();
        }
        return cloc;
    }
}

